package com.ejianc.framework.skeleton.refer.common.service.impl;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.refer.common.mapper.CommonReferMapper;
import com.ejianc.framework.skeleton.refer.common.service.CommonReferService;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;

/**  
  * Title: CommonReferServiceImpl  
  * Description: 
  * @author guominga  
  * @date 2020年2月13日  
  */
@Service
public class CommonReferServiceImpl implements CommonReferService {
	private final static org.slf4j.Logger Log = LoggerFactory.getLogger(CommonReferServiceImpl.class);
	
	@Autowired
	private CommonReferMapper commonReferMapper;

	@Override
	public JSONArray getReferEntity(Map<String, Object> refMapList) {
		JSONArray json = new JSONArray();
		String valueId = refMapList.get("valueId").toString();
		StringBuffer parameters = new StringBuffer("");
		for(String key : refMapList.keySet()){
			if(!key.equals("valueId")&&!key.equals("databaseName")&&!key.equals("tableName")){
				parameters.append(refMapList.get(key)).append(" as ").append(key).append(",");
			}
		}
		if(StringUtils.isBlank(parameters)){
			Log.error("---------------参照转换字段为空-----------");
			ExceptionUtil.wrappBusinessException("参照转换字段为空");
		} else {
			if(refMapList.get("databaseName")==null){
				Log.error("---------------参照转换时数据库字段为空-----------");
				ExceptionUtil.wrappBusinessException("参照转换时数据库字段为空");
			}
			if(refMapList.get("tableName")==null){
				Log.error("---------------参照转换时表名字段为空-----------");
				ExceptionUtil.wrappBusinessException("参照转换时表名字段为空");
			}
			String databaseName = refMapList.get("databaseName").toString();
			String tableName = refMapList.get("tableName").toString();
			String parameter = parameters.substring(0, parameters.length()-1);
			if(tableName.indexOf("tenantId") != -1) {
				String tableNewName = tableName.replace("${tenantId}", InvocationInfoProxy.getTenantid().toString());
				List<String> tables = commonReferMapper.queryTables(databaseName,tableNewName);
				if(tables.size() > 0) {
					json = commonReferMapper.getReferEntity(parameter,databaseName,tableNewName,valueId);
				}else{
					tableNewName = tableName.replace("${tenantId}", "999999");
					json = commonReferMapper.getReferEntity(parameter,databaseName,tableNewName,valueId);
				}
			}else{
				//获取到数据库服务
				json = commonReferMapper.getReferEntity(parameter,databaseName,tableName,valueId);
			}
		}
		return json;
	}

	@Override
	public JSONObject getAuditInfoEntity(Map<String, Object> refMapList) {
		String userCode = (String) refMapList.get("userCode");
		if(StringUtils.isNotBlank(userCode)) {
			JSONArray jsonArray = commonReferMapper.getAuditInfoEntity(userCode);
			if(jsonArray.size() > 0) {
				return jsonArray.getJSONObject(0);
			}
		}
		return null;
	}

}
