package com.ejianc.framework.skeleton.template;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.ejianc.framework.skeleton.template.es.EsEntity;
import com.ejianc.framework.skeleton.template.es.IBaseEsQueryDao;
import com.ejianc.framework.skeleton.template.es.TableInfoTool;

/**
 * 集成mybatis plus的serviceImpl，各业务service都集成之。
 * @author guominga
 *
 * @param <M>
 * @param <T>
 */
public class BaseServiceImpl<M extends BaseCrudMapper<T>, T> extends ServiceImpl<M, T> implements IBaseService<T> {
	private final Logger logger = LoggerFactory.getLogger(getClass());
	
	@Autowired
	private RabbitTemplate rabbitTemplate;
	@Autowired
	private IBaseEsQueryDao<T> baseEsQueryDao;
	@Autowired
	private ICustomBusinessDataService customBusinessDataService;

	@Value("${spring.application.name}")
	private String applicationName;
	
	@Value("${extend.field.mode:false}")
	private Boolean extFieldsMode;

	/**
	 * 增加或修改对象
	 *
	 * @param entity 实体对象
	 * @param syncEs 是否同步es
	 */
	@Transactional
	public boolean saveOrUpdate(T entity, boolean syncEs) {
		//增加数据--主表
		boolean isSuccess = super.saveOrUpdate(entity);
		//处理子表
		if(isSuccess){
			Class<?> mainClass = entity.getClass();
			
			if(extFieldsMode) {
				/**主表扩展字段begin*/
				try {
					Method customFieldMethod =  mainClass.getSuperclass().getDeclaredMethod("getCustomField",  null);
					Map<String, Object> customFieldDataMap = (Map<String, Object>) customFieldMethod.invoke(entity, (Object[]) null);
					if(customFieldDataMap != null && !customFieldDataMap.isEmpty()) {
						CustomBusinessDataVO customBusinessDataVO = new CustomBusinessDataVO();
						Method mainPkIdMethod =  mainClass.getSuperclass().getDeclaredMethod("getId",  null);
						Long businessId = (Long) mainPkIdMethod.invoke(entity, (Object[]) null);
						customBusinessDataVO.setBusinessId(businessId);
						customBusinessDataVO.setBusinessData(JSON.toJSONString(customFieldDataMap));
						
						List<CustomBusinessDataVO> customBusinessDataVos = new ArrayList<>();
						customBusinessDataVos.add(customBusinessDataVO);
						CommonResponse<String> mainResponse = customBusinessDataService.saveOrUpdateData(customBusinessDataVos);
						if(!mainResponse.isSuccess()) {
							throw new BusinessException("主表扩展字段插入失败！"); 
						}
					}
				} catch (Exception e) {
					logger.warn("扩展数据存储或读取失败， 如果有使用扩展字段，请在您的微服务数据库中建立ejc_custom_businessdata表");
				}
				/**主表扩展字段end*/
			}
			
			TableInfo tableInfo = TableInfoHelper.getTableInfo(mainClass);
			Object pid = ReflectionKit.getMethodValue(mainClass, entity, tableInfo.getKeyProperty());
			List<Field> subFieldsList = new ArrayList<>();
			Field[] fields = mainClass.getDeclaredFields();
			/** 查找字表字段 可能有多个子表*/
			for (Field field : fields) {
				if(field.isAnnotationPresent(SubEntity.class)){
					subFieldsList.add(field);
				}
			}
			if(!ListUtil.isEmpty(subFieldsList)){
				T finalEntity = entity;
				subFieldsList.forEach(field -> {
					/** 字表字段名 */
					String fieldName = field.getName();
					try {
						/** 获取子表get方法*/
						Method m =  mainClass.getDeclaredMethod("get"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),  null);
						/** 获取子表数据 */
						List<T> subList = (List<T>)m.invoke(finalEntity, (Object[]) null);
						//定义子表扩展数据
						List<CustomBusinessDataVO> subCustomBusinessDataVos = new ArrayList<>();
						if(!ListUtil.isEmpty(subList)){
							SubEntity subEntity = field.getAnnotation(SubEntity.class);
							List<T> delSubList = new ArrayList<>();
							List<Object> delSubListIds = new ArrayList<>();
							/** 将主表id赋值给子表*/
							subList.forEach(s->{
								String p = subEntity.pidName();
								if(StringUtils.isBlank(p)){
									throw new BusinessException("字段【"+fieldName+"】注解SubEntity未设置pidName！");
								}
								Class<?> subClass = s.getClass();
								try {
									Method subPid = subClass.getDeclaredMethod("set"+p.substring(0,1).toUpperCase()+p.substring(1), Long.class);
									subPid.invoke(s,pid);
									Method getRowState = subClass.getSuperclass().getDeclaredMethod("getRowState",  null);
									String o = (String)getRowState.invoke(s, (Object[]) null);
									/** 处理子表删除 */
									
									Method subCustomFieldMethod =  subClass.getSuperclass().getDeclaredMethod("getCustomField",  null);
									Map<String, Object> subCustomFieldMap = (Map<String, Object>) subCustomFieldMethod.invoke(s, (Object[]) null);
									if(StringUtils.isNotBlank(o)&&"del".equals(o)){
										Method setDr = subClass.getSuperclass().getDeclaredMethod("setDr", Integer.class);
										setDr.invoke(s,1);
										TableInfo subtableInfo = TableInfoHelper.getTableInfo(subClass);
										Object idVal = ReflectionKit.getMethodValue(subClass, s, subtableInfo.getKeyProperty());
										delSubListIds.add(idVal);
										delSubList.add(s);
										
										//子表扩展字段
										if(subCustomFieldMap != null && !subCustomFieldMap.isEmpty()) {
											CustomBusinessDataVO subCustomBusinessDataVO = new CustomBusinessDataVO();
											Method subPkIdMethod =  subClass.getSuperclass().getDeclaredMethod("getId",  null);
											Long businessId = (Long) subPkIdMethod.invoke(s, (Object[]) null);
											subCustomBusinessDataVO.setBusinessId(businessId);
											subCustomBusinessDataVos.add(subCustomBusinessDataVO);
										}
									}else {
										Method setRowState = subClass.getSuperclass().getDeclaredMethod("setRowState",  String.class);
										setRowState.invoke(s,(String)null);
										
										//子表扩展字段新增修改
										CustomBusinessDataVO subCustomBusinessDataVO = new CustomBusinessDataVO();
										if(subCustomFieldMap != null && !subCustomFieldMap.isEmpty()) {
											Method subPkIdMethod =  subClass.getSuperclass().getDeclaredMethod("getId",  null);
											Long businessId = (Long) subPkIdMethod.invoke(s, (Object[]) null);
											subCustomBusinessDataVO.setBusinessId(businessId);
											subCustomBusinessDataVO.setBusinessData(JSON.toJSONString(subCustomFieldMap));
										}else {// 删除
											Method subPkIdMethod =  subClass.getSuperclass().getDeclaredMethod("getId",  null);
											Long businessId = (Long) subPkIdMethod.invoke(s, (Object[]) null);
											subCustomBusinessDataVO.setBusinessId(businessId);
										}
										subCustomBusinessDataVos.add(subCustomBusinessDataVO);
									}
								} catch (NoSuchMethodException e) {
									throw new BusinessException("类【"+subClass+"】的字段【"+p+"】未设置get方法！");
								} catch (IllegalAccessException e) {
									throw new BusinessException("类【"+subClass+"】的字段【"+p+"】的get方法需要设置成public属性！");
								} catch (InvocationTargetException e) {
									throw new BusinessException("类【"+subClass+"】的字段【"+p+"】的get方法调用失败！");
								}
							});
							/** 查找子表实现服务类 */
							String serviceName = subEntity.serviceName();
							if(StringUtils.isBlank(serviceName)){
								throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
							}
							BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
							if(subService==null){
								throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
							}
							/** 批量新增子表数据 */
							subList.removeAll(delSubList);
							if(!ListUtil.isEmpty(subList)){
								subService.saveOrUpdateBatch(subList);
							}
							if(!ListUtil.isEmpty(delSubListIds)){
								subService.removeByIds(delSubListIds);
							}
							
							try {
								if(extFieldsMode && !ListUtil.isEmpty(subCustomBusinessDataVos)) {
									customBusinessDataService.saveOrUpdateData(subCustomBusinessDataVos);
								}
							}catch(Exception e) {
								logger.warn("扩展数据存储或读取失败， 如果有使用扩展字段，请在您的微服务数据库中建立ejc_custom_businessdata表");
							}
						}
					} catch (NoSuchMethodException e) {
						throw new BusinessException("子表字段【"+fieldName+"】未设置get方法！");
					} catch (IllegalAccessException e) {
						throw new BusinessException("子表字段【"+fieldName+"】的get方法需要设置成public属性！");
					} catch (InvocationTargetException e) {
						throw new BusinessException("子表字段【"+fieldName+"】的get方法调用失败！");
					}
				});
			}
		}else {
			throw new BusinessException("数据已被您的同事修改，请刷新页面获取最新数据再保存！");
		}
		//插入mq
		if(isSuccess && syncEs) {
			TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
			String indexName = tableInfo.getTableName();
			EsEntity esEntity = new EsEntity();

			esEntity.setIndexName(indexName);
			esEntity.setType("insertOrUpdateOne");
			esEntity.setContent(JSON.toJSONString(entity));
			//插入mq
			MqMessage mqMessage = new MqMessage();
			mqMessage.setBody(esEntity);
			rabbitTemplate.convertAndSend(applicationName, mqMessage);
		}
		return isSuccess;
	}

	/**
	 * 增加或修改对象 不走es
	 *
	 * @param entity 实体对象
	 */
	@Override
	public boolean saveOrUpdateNoES(T entity) {
		return saveOrUpdate(entity,false);
	}

	/**
	 * 批量增加或修改对象
	 *
	 * @param entityList 实体对象list
	 * @param batchSize 一次批量增加或修改对象数量
	 * @param syncEs 是否同步es
	 */
	public boolean saveOrUpdateBatch(List<T> entityList, int batchSize, boolean syncEs) {
		boolean isSuccess = super.saveOrUpdateBatch(entityList, batchSize);
		if(isSuccess && syncEs) {
			TableInfo tableInfo = TableInfoTool.initTableInfo(entityList.get(0).getClass());
			String indexName = tableInfo.getTableName();
			EsEntity esEntity = new EsEntity();

			esEntity.setIndexName(indexName);
			esEntity.setType("insertOrUpdateBatch");
			esEntity.setContent(JSON.toJSONString(entityList));
			//插入mq
			MqMessage mqMessage = new MqMessage();
			mqMessage.setBody(esEntity);
			rabbitTemplate.convertAndSend(applicationName, mqMessage);
		}
		return isSuccess;
	}

	/**
	 * 根据主键ID查询对象
	 *
	 * @param id 主键id
	 */
	@SuppressWarnings("unchecked")
	@Override
	public T selectById(Serializable id) {
		return selectById(id,null);
	}

	/**
	 * 根据主键ID查询对象
	 * 支持子表排序
	 * @param id 主键id
	 * @param subOrderMap Map<子表在主表的list键值,LinkedHashMap<排序字段,排序方式ASC或者DESC>>
	 */
	@Override
	public T selectById(Serializable id,Map<String,LinkedHashMap<String,String>> subOrderMap) {
		T entity = baseMapper.selectById(id);
		if(entity==null){
			return null;
		}
		
		if(extFieldsMode) {
			/**主表扩展字段查询begin*/
			try {
				List<Long> businessIdList = new ArrayList<>();
				businessIdList.add((Long) id);
				CommonResponse<Map<Long, CustomBusinessDataVO>> mainCustomBusinessDataResponse = customBusinessDataService.queryCustomBusinessData(businessIdList);
				if(mainCustomBusinessDataResponse.isSuccess()) {
					Map<Long, CustomBusinessDataVO> mainCustomBusinessDataMap = mainCustomBusinessDataResponse.getData();
					if(!mainCustomBusinessDataMap.isEmpty()) {
						CustomBusinessDataVO customBusinessDataVo = mainCustomBusinessDataMap.get(id);
						Class<?> mainClass = entity.getClass(); 
						Method customFieldMethod = mainClass.getSuperclass().getDeclaredMethod("setCustomField",  Map.class);
						
						Map<String, Object> customField = JSONObject.parseObject(customBusinessDataVo.getBusinessData());
						customFieldMethod.invoke(entity, customField);
					}
				}
			}catch(Exception e) {
				logger.warn("扩展数据存储或读取失败， 如果有使用扩展字段，请在您的微服务数据库中建立ejc_custom_businessdata表");
			}
			/**主表扩展字段查询end*/
		}
		
		Class<?> mainClass = entity.getClass();
		Field[] fields = mainClass.getDeclaredFields();
		/** 查找字表字段 可能有多个子表*/
		for (Field field : fields) {
			if(field.isAnnotationPresent(SubEntity.class)){
				SubEntity subEntity = field.getAnnotation(SubEntity.class);
				String serviceName = subEntity.serviceName();
				String fieldName = field.getName();
				if(StringUtils.isBlank(serviceName)){
					throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
				}
				BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
				if(subService==null){
					throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
				}
				QueryParam queryParam = new QueryParam();
				queryParam.getParams().put(subEntity.pidName(), new Parameter(QueryParam.EQ, id));
				if(subOrderMap!=null){
					if(subOrderMap.get(fieldName)!=null){
						queryParam.setOrderMap(subOrderMap.get(fieldName));
					}else {
						queryParam.getOrderMap().put("id",QueryParam.ASC);
					}
				}else {
					queryParam.getOrderMap().put("id",QueryParam.ASC);
				}
				List<T> subList = subService.queryList(queryParam,false);
				
				if(extFieldsMode) {
					/**子表扩展字段查询begin*/
					try {
						if(subList != null && subList.size() > 0) {
							List<Long> subBusinessIdList = new ArrayList<>();
							for(T sub:subList) {
								Class<?> subClass = sub.getClass();
								Method subPkIdMethod =  subClass.getSuperclass().getDeclaredMethod("getId",  null);
								Long businessId = (Long) subPkIdMethod.invoke(sub, (Object[]) null);
								subBusinessIdList.add(businessId);
							}
							CommonResponse<Map<Long, CustomBusinessDataVO>> subCustomBusinessDataResponse = customBusinessDataService.queryCustomBusinessData(subBusinessIdList);
							if(subCustomBusinessDataResponse.isSuccess()) {
								Map<Long, CustomBusinessDataVO> subCustomBusinessDataMap = subCustomBusinessDataResponse.getData();
								for(T sub:subList) {
									Class<?> subClass = sub.getClass();
									Method subPkIdMethod =  subClass.getSuperclass().getDeclaredMethod("getId",  null);
									Long businessId = (Long) subPkIdMethod.invoke(sub, (Object[]) null);
									
									CustomBusinessDataVO subCustomBusinessDataVo = subCustomBusinessDataMap.get(businessId);
									if(subCustomBusinessDataVo != null) {
										Method subCustomFieldMethod = subClass.getSuperclass().getDeclaredMethod("setCustomField",  Map.class);
										
										Map<String, Object> subCustomField = JSONObject.parseObject(subCustomBusinessDataVo.getBusinessData());
										subCustomFieldMethod.invoke(sub, subCustomField);
									}
								}
							}
							
						}
					}catch(Exception e) {
						logger.warn("扩展数据存储或读取失败， 如果有使用扩展字段，请在您的微服务数据库中建立ejc_custom_businessdata表");
					}
					/**子表扩展字段查询end*/
				}
				
				try {
					Class[] cArg = new Class[1];
					cArg[0] = field.getType();
					Method setSubList = mainClass.getDeclaredMethod("set"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),cArg);
					setSubList.invoke(entity,subList);
				} catch (NoSuchMethodException e) {
					throw new BusinessException("字段【"+fieldName+"】未定义set方法！");
				} catch (IllegalAccessException e) {
					throw new BusinessException("字段【"+fieldName+"】set方法需要是public属性！");
				} catch (InvocationTargetException e) {
					throw new BusinessException("字段【"+fieldName+"】set方法执行出错！");
				}

			}
		}
		return entity;
	}

	/**
	 * 根据主键ID删除对象
	 *
	 * @param id 主键id
	 * @param syncEs 是否同步es
	 */
	public boolean removeById(Serializable id, boolean syncEs) {
		boolean isSuccess = false;
		T entity = this.selectById(id);
		if(entity != null) {
			isSuccess = super.removeById(id);
			
			//删除主表
			if(isSuccess){
				Class<?> mainClass = entity.getClass();
				
				try {
					if(extFieldsMode) {
						/**删除主表扩展字段begin*/
						List<Long> mainBusinessIdList = new ArrayList<>();
						mainBusinessIdList.add((Long) id);
						customBusinessDataService.deleteCustomBusinessData(mainBusinessIdList);
						/**删除主表扩展字段end*/
					}
				}catch(Exception e) {
					logger.warn("扩展数据存储或读取失败， 如果有使用扩展字段，请在您的微服务数据库中建立ejc_custom_businessdata表");
				}
				
				Field[] fields = mainClass.getDeclaredFields();
				/** 查找字表字段 可能有多个子表*/
				for (Field field : fields) {
					if(field.isAnnotationPresent(SubEntity.class)){
						SubEntity subEntity = field.getAnnotation(SubEntity.class);
						String serviceName = subEntity.serviceName();
						String fieldName = field.getName();
						if(StringUtils.isBlank(serviceName)){
							throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
						}
						BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
						if(subService==null){
							throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
						}
						try {
							Method getSubList = mainClass.getDeclaredMethod("get"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),  null);
							List<BaseEntity> subs =  (List<BaseEntity>)getSubList.invoke(entity, (Object[]) null);
							if(!ListUtil.isEmpty(subs)){
								subService.removeByIds(subs.stream().map(BaseEntity::getId).collect(Collectors.toList()),false);
								
								try{
									if(extFieldsMode) {
										//子表扩展字段删除
										customBusinessDataService.deleteCustomBusinessData(subs.stream().map(BaseEntity::getId).collect(Collectors.toList()));
									}
								}catch(Exception e) {
									logger.warn("扩展数据存储或读取失败， 如果有使用扩展字段，请在您的微服务数据库中建立ejc_custom_businessdata表");
								}
							}
						} catch (NoSuchMethodException e) {
							throw new BusinessException("字段【"+fieldName+"】未定义set方法！");
						} catch (IllegalAccessException e) {
							throw new BusinessException("字段【"+fieldName+"】set方法需要是public属性！");
						} catch (InvocationTargetException e) {
							throw new BusinessException("字段【"+fieldName+"】set方法执行出错！");
						}

					}
				}
			}
			if(isSuccess && syncEs) {
				TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
				String indexName = tableInfo.getTableName();
				EsEntity esEntity = new EsEntity();

				esEntity.setIndexName(indexName);
				esEntity.setType("deleteById");
				esEntity.setContent(id.toString());
				//插入mq
				MqMessage mqMessage = new MqMessage();
				mqMessage.setBody(esEntity);
				rabbitTemplate.convertAndSend(applicationName, mqMessage);
			}
		}
		return isSuccess;
	}

	/**
	 * 根据map删除对象
	 *
	 * @param columnMap 参数map
	 * @param syncEs 是否同步es
	 */
	public boolean removeByMap(Map<String, Object> columnMap, boolean syncEs) {
		boolean isSuccess = false;
		Collection<T> list = super.listByMap(columnMap);
		if(list != null && list.size() > 0) {
			isSuccess = super.removeByMap(columnMap);

			if(isSuccess && syncEs) {
				//循环Collection
				T tableBean = null;
				List<Long> ids = new ArrayList<Long>();
				for(T bean:list) {
					tableBean = bean;

					BaseEntity baseEntity = (BaseEntity) bean;
					ids.add(baseEntity.getId());
				}

				TableInfo tableInfo = TableInfoTool.initTableInfo(tableBean.getClass());
				String indexName = tableInfo.getTableName();
				EsEntity esEntity = new EsEntity();

				esEntity.setIndexName(indexName);
				esEntity.setType("deleteBatch");
				esEntity.setContent(JSON.toJSONString(ids));
				//插入mq
				MqMessage mqMessage = new MqMessage();
				mqMessage.setBody(esEntity);
				rabbitTemplate.convertAndSend(applicationName, mqMessage);
			}
		}
		return isSuccess;
	}

	/**
	 * 根据wrapper条件删除对象
	 *
	 * @param wrapper 参数条件
	 * @param syncEs 是否同步es
	 */
	public boolean remove(Wrapper<T> wrapper, boolean syncEs){
		boolean isSuccess = false;
		List<T> list = super.list(wrapper);
		if(list != null && list.size() > 0) {
			isSuccess = super.remove(wrapper);

			if(isSuccess && syncEs) {
				//循环Collection
				T tableBean = null;
				List<Long> ids = new ArrayList<Long>();
				for(T bean:list) {
					tableBean = bean;

					BaseEntity baseEntity = (BaseEntity) bean;
					ids.add(baseEntity.getId());
				}

				TableInfo tableInfo = TableInfoTool.initTableInfo(tableBean.getClass());
				String indexName = tableInfo.getTableName();
				EsEntity esEntity = new EsEntity();

				esEntity.setIndexName(indexName);
				esEntity.setType("deleteBatch");
				esEntity.setContent(JSON.toJSONString(ids));
				//插入mq
				MqMessage mqMessage = new MqMessage();
				mqMessage.setBody(esEntity);
				rabbitTemplate.convertAndSend(applicationName, mqMessage);
			}
		}
		return isSuccess;
	}

	/**
	 * 根据主键Idlist删除满足条件的对象
	 *
	 * @param idList 参数条件
	 * @param syncEs 是否同步es
	 */
	public boolean removeByIds(Collection<? extends Serializable> idList, boolean syncEs) {
		boolean isSuccess = false;
		for(Serializable id : idList){
			isSuccess = this.removeById(id,syncEs);
			if(!isSuccess){
				throw new BusinessException("删除失败");
			}
		}
		/*
		Collection<T> list = super.listByIds(idList);
		
		if(list != null && list.size() > 0) {
			isSuccess = super.removeByIds(idList);
			if(isSuccess){
				list.forEach(entity->{
					Class<?> mainClass = entity.getClass();
					Field[] fields = mainClass.getDeclaredFields();
					*//** 查找字表字段 可能有多个子表*//*
					for (Field field : fields) {
						if(field.isAnnotationPresent(SubEntity.class)){
							SubEntity subEntity = field.getAnnotation(SubEntity.class);
							String serviceName = subEntity.serviceName();
							String fieldName = field.getName();
							if(StringUtils.isBlank(serviceName)){
								throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
							}
							BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
							if(subService==null){
								throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
							}
							try {
								Method getSubList = mainClass.getDeclaredMethod("get"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),  null);
								List<BaseEntity> subs =  (List<BaseEntity>)getSubList.invoke(entity, (Object[]) null);
								if(!ListUtil.isEmpty(subs)){
									subService.removeByIds(subs.stream().map(BaseEntity::getId).collect(Collectors.toList()),false);
								}
							} catch (NoSuchMethodException e) {
								throw new BusinessException("字段【"+fieldName+"】未定义set方法！");
							} catch (IllegalAccessException e) {
								throw new BusinessException("字段【"+fieldName+"】set方法需要是public属性！");
							} catch (InvocationTargetException e) {
								throw new BusinessException("字段【"+fieldName+"】set方法执行出错！");
							}

						}
					}
				});
			}
			
			if(isSuccess && syncEs) {
				//循环Collection
				T tableBean = null;
				List<Long> ids = new ArrayList<Long>();
				for(T bean:list) {
					tableBean = bean;
					
					BaseEntity baseEntity = (BaseEntity) bean;
					ids.add(baseEntity.getId());
				}
				
				TableInfo tableInfo = TableInfoTool.initTableInfo(tableBean.getClass());
				String indexName = tableInfo.getTableName();
				EsEntity esEntity = new EsEntity();
				
				esEntity.setIndexName(indexName);
				esEntity.setType("deleteBatch");
				esEntity.setContent(JSON.toJSONString(ids));
				//插入mq
				MqMessage mqMessage = new MqMessage();
				mqMessage.setBody(esEntity);
				rabbitTemplate.convertAndSend(applicationName, mqMessage);
			}
		}*/
		return isSuccess;
	}

	/**
	 * 根据wrapper修改对象
	 *
	 * @param entity 实体对象
	 * @param updateWrapper 条件
	 * @param syncEs 是否同步es
	 */
	public boolean update(T entity, Wrapper<T> updateWrapper, boolean syncEs) {
		//增加数据
		boolean isSuccess = super.update(entity, updateWrapper);
		//插入mq
		if(isSuccess && syncEs) {
			TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
			String indexName = tableInfo.getTableName();
			EsEntity esEntity = new EsEntity();

			esEntity.setIndexName(indexName);
			esEntity.setType("insertOrUpdateOne");
			esEntity.setContent(JSON.toJSONString(entity));
			//插入mq
			MqMessage mqMessage = new MqMessage();
			mqMessage.setBody(esEntity);
			rabbitTemplate.convertAndSend(applicationName, mqMessage);
		}
		return isSuccess;
	}

	/**
	 * 根据查询对象查询list
	 *
	 * @param queryParam 查询参数
	 * @param isEs 是否查询es
	 * @return
	 */
	@Override
	public List<T> queryList(QueryParam queryParam, boolean isEs) {
		List<T> list;
		if(isEs) { //查询es
			list = baseEsQueryDao.selectList(queryParam);
		}else{ //查询数据库
			QueryWrapper<T> queryWrapper = new QueryWrapper<>();
			Map<String, Parameter> params = queryParam.getParams();
			/** 模糊查询配置的字段 */
			if(StringUtils.isNotBlank(queryParam.getSearchText()) && !ListUtil.isEmpty(queryParam.getFuzzyFields())){
				String searchText = queryParam.getSearchText();
				List<String> fuzzyFields = queryParam.getFuzzyFields();
				if(queryParam.getFuzzyFields().size()==1){
					queryWrapper.like(CamelAndUnderLineConverter.humpToLine(queryParam.getFuzzyFields().get(0)), searchText);
				}else {
					queryWrapper.and(wrapper ->{
						for (int i = 0; i < fuzzyFields.size(); i++) {
							wrapper.like(CamelAndUnderLineConverter.humpToLine(queryParam.getFuzzyFields().get(i)),searchText);
							if(i!=fuzzyFields.size()-1){
								wrapper.or();
							}
						}
						return wrapper;
					});
				}
			}
			/** 基础字段查询*/
			setParam(queryWrapper,params);

			/** 具体模糊查询字段 */
			if(StringUtils.isNotEmpty(queryParam.getSearchObject())){
				setSearchObjectParam(queryWrapper,JSONObject.parseObject(queryParam.getSearchObject()));
			}
			/** 复杂查询 */
			List<ComplexParam> complexParams = queryParam.getComplexParams();
			if(!ListUtil.isEmpty(complexParams)){
				complexParams.forEach(c->{
					if(ComplexParam.AND.equals(c.getLogic())){
						queryWrapper.and(w-> setWrapper(w,c));
					}else {
						queryWrapper.or(w-> setWrapper(w,c));
					}
				});
			}

			/** 设置整体排序方式 */
			Map<String, String> orderMap = queryParam.getOrderMap();
			for(String key : orderMap.keySet()){
				String value = orderMap.get(key);
				if(QueryParam.ASC.equals(value.toLowerCase())){
					queryWrapper.orderByAsc(CamelAndUnderLineConverter.humpToLine(key));
				}else if(QueryParam.DESC.equals(value.toLowerCase())){
					queryWrapper.orderByDesc(CamelAndUnderLineConverter.humpToLine(key));
				}
			}
			list = this.list(queryWrapper);
		}
		return list;
	}

	private static <T> QueryWrapper<T> setWrapper(QueryWrapper<T> w,ComplexParam c){
		/** 基础字段查询*/
		if(c.getParams()!=null && !c.getParams().isEmpty()){
			setParam(w,c.getParams());
		}
		List<ComplexParam> complexParams = c.getComplexParams();
		if(!ListUtil.isEmpty(complexParams)){
			complexParams.forEach(complex->{
				if(ComplexParam.AND.equals(complex.getLogic())){
					w.and(wrapper-> setWrapper(wrapper,complex));
				}else {
					w.or(wrapper-> setWrapper(wrapper,complex));
				}
			});
		}
		return w;
	}

	/**
	 * 查询分页对象
	 *
	 * @param queryParam 查询参数
	 * @param isEs 是否查询es
	 * @return
	 */
	@Override
	public IPage<T> queryPage(QueryParam queryParam, boolean isEs) {
		IPage<T> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		/** pageSize = -1 查询全部数据 */
		if(queryParam.getPageSize() == -1){
			List<T> records = this.queryList(queryParam,isEs);
			page.setRecords(records);
			return page;
		}
		if(isEs) {
			page = baseEsQueryDao.selectPage(page, queryParam);
		}else{
			page = this.page(page, changeToQueryWrapper(queryParam));
			
			try {
				if(extFieldsMode) {
					/**列表查询扩展字段begin*/
					List<T> records = page.getRecords();
					if(records != null && records.size() > 0) {
						List<Long> businessIdList = new ArrayList<>();
						for(T record:records) {
							Class<?> clazz = record.getClass();
							Method mainPkIdMethod =  clazz.getSuperclass().getDeclaredMethod("getId",  null);
							Long businessId = (Long) mainPkIdMethod.invoke(record, (Object[]) null);
							businessIdList.add(businessId);
						}
						CommonResponse<Map<Long, CustomBusinessDataVO>> customBusinessDataResponse = customBusinessDataService.queryCustomBusinessData(businessIdList);
						if(customBusinessDataResponse.isSuccess()) {
							Map<Long, CustomBusinessDataVO> customBusinessDataMap = customBusinessDataResponse.getData();
							for(T record:records) {
								Class<?> clazz = record.getClass();
								Method mainPkIdMethod =  clazz.getSuperclass().getDeclaredMethod("getId",  null);
								Long businessId = (Long) mainPkIdMethod.invoke(record, (Object[]) null);
								
								CustomBusinessDataVO subCustomBusinessDataVo = customBusinessDataMap.get(businessId);
								if(subCustomBusinessDataVo != null) {
									Method subCustomFieldMethod = clazz.getSuperclass().getDeclaredMethod("setCustomField",  Map.class);
									
									Map<String, Object> subCustomField = JSONObject.parseObject(subCustomBusinessDataVo.getBusinessData());
									subCustomFieldMethod.invoke(record, subCustomField);
								}
							}
						}
					}
				/**列表查询扩展字段end*/
				}
			}catch(Exception e) {
				logger.warn("扩展数据存储或读取失败， 如果有使用扩展字段，请在您的微服务数据库中建立ejc_custom_businessdata表");
			}
		}
		return page;
	}

	/**
	 * 根据查询对象查询list
	 *
	 * @param queryParam 查询参数 默认不走es
	 * @return
	 */
	@Override
	public List<T> queryList(QueryParam queryParam) {
		return this.queryList(queryParam,false);
	}

	/**
	 * 查询分页对象
	 *
	 * @param queryParam 查询参数 默认不走es
	 * @return
	 */
	@Override
	public IPage<T> queryPage(QueryParam queryParam) {
		return this.queryPage(queryParam,false);
	}


	/** 基础字段查询*/
	private static <T> void setParam(QueryWrapper<T> queryWrapper, Map<String, Parameter> params){
		for(Map.Entry<String, Parameter> entry: params.entrySet()){
			Parameter param = entry.getValue();
			String type = param.getType();
			if(!isValidKey(entry.getKey().toLowerCase())){
				throw new BusinessException("存在非法查询参数key："+entry.getKey());
			}
			if(param.getValue() != null){
				if(!isValidKey(param.getValue().toString().toLowerCase())){
					throw new BusinessException("存在非法查询参数值："+entry.getKey()+":"+param.getValue());
				}
			}
			switch(type) {
				case QueryParam.EQ:
					if(null == param.getValue()) {
						queryWrapper.isNull(CamelAndUnderLineConverter.humpToLine(entry.getKey()));
					} else {
						queryWrapper.eq(CamelAndUnderLineConverter.humpToLine(entry.getKey()), param.getValue());
					}
					break;
				case QueryParam.NE:
					if(null == param.getValue()) {
						queryWrapper.isNotNull(CamelAndUnderLineConverter.humpToLine(entry.getKey()));
					} else {
						queryWrapper.ne(CamelAndUnderLineConverter.humpToLine(entry.getKey()), param.getValue());
					}
					break;
				case QueryParam.SQL:
					/** 严禁前端直接传入 仅用于后端使用 ！！！ */
					if(param.getValue()!=null) {
						queryWrapper.apply(param.getValue().toString());
					}
					break;
				case QueryParam.IN:
					if(param.getValue() instanceof List) {
						queryWrapper.in(CamelAndUnderLineConverter.humpToLine(entry.getKey()), (List<?>)param.getValue());
					}else if(param.getValue() instanceof String) {
						String[] paramArr = param.getValue().toString().split(",");
						queryWrapper.in(CamelAndUnderLineConverter.humpToLine(entry.getKey()), paramArr);

					}
					break;
				case QueryParam.NOT_IN:
					if(param.getValue() instanceof List) {
						queryWrapper.notIn(CamelAndUnderLineConverter.humpToLine(entry.getKey()), (List<?>)param.getValue());
					}else if(param.getValue() instanceof String) {
						String[] paramArr = param.getValue().toString().split(",");
						queryWrapper.notIn(CamelAndUnderLineConverter.humpToLine(entry.getKey()), paramArr);

					}
					break;
				case QueryParam.LIKE:
					if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
						queryWrapper.like(CamelAndUnderLineConverter.humpToLine(entry.getKey()), param.getValue());
					}
					break;
				case QueryParam.NOT_LIKE:
					if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
						queryWrapper.notLike(CamelAndUnderLineConverter.humpToLine(entry.getKey()), param.getValue());
					}
					break;
				case QueryParam.LIKE_LEFT:
					if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
						queryWrapper.likeLeft(CamelAndUnderLineConverter.humpToLine(entry.getKey()), param.getValue());
					}
					break;
				case QueryParam.LIKE_RIGHT:
					if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
						queryWrapper.likeRight(CamelAndUnderLineConverter.humpToLine(entry.getKey()), param.getValue());
					}
					break;
				case QueryParam.BETWEEN:
					if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
						String[] paramArr = param.getValue().toString().split(",");
						queryWrapper.between(CamelAndUnderLineConverter.humpToLine(entry.getKey()), paramArr[0],paramArr[1]);
					}
					break;
				case QueryParam.LT:
					if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
						queryWrapper.lt(CamelAndUnderLineConverter.humpToLine(entry.getKey()), param.getValue());
					}
					break;
				case QueryParam.LE:
					if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
						queryWrapper.le(CamelAndUnderLineConverter.humpToLine(entry.getKey()), param.getValue());
					}
					break;
				case QueryParam.GT:
					if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
						queryWrapper.gt(CamelAndUnderLineConverter.humpToLine(entry.getKey()), param.getValue());
					}
					break;
				case QueryParam.GE:
					if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
						queryWrapper.ge(CamelAndUnderLineConverter.humpToLine(entry.getKey()), param.getValue());
					}
					break;
			}
		}
	}


	/** 基础字段查询*/
	private static <T> void setSearchObjectParam(QueryWrapper<T> queryWrapper, JSONObject params){
		for(String key: params.keySet()){
			queryWrapper.eq(CamelAndUnderLineConverter.humpToLine(key), params.get(key));
		}
	}


	public static <T> QueryWrapper<T> changeToQueryWrapper(QueryParam queryParam) {
		QueryWrapper<T> queryWrapper = new QueryWrapper<>();
		Map<String, Parameter> params = queryParam.getParams();
		/** 模糊查询配置的字段 */
		if(StringUtils.isNotBlank(queryParam.getSearchText()) && !ListUtil.isEmpty(queryParam.getFuzzyFields())){
			String searchText = queryParam.getSearchText();
			List<String> fuzzyFields = queryParam.getFuzzyFields();
			if(queryParam.getFuzzyFields().size()==1){
				queryWrapper.like(CamelAndUnderLineConverter.humpToLine(queryParam.getFuzzyFields().get(0)), searchText);
			}else {
				queryWrapper.and(wrapper ->{
					for (int i = 0; i < fuzzyFields.size(); i++) {
						wrapper.like(CamelAndUnderLineConverter.humpToLine(queryParam.getFuzzyFields().get(i)),searchText);
						if(i!=fuzzyFields.size()-1){
							wrapper.or();
						}
					}
					return wrapper;
				});
			}
		}
		/** 基础字段查询*/
		setParam(queryWrapper,params);

		/** 具体模糊查询字段 */
		if(StringUtils.isNotEmpty(queryParam.getSearchObject())){
			setSearchObjectParam(queryWrapper,JSONObject.parseObject(queryParam.getSearchObject()));
		}

		/** 复杂查询 */
		List<ComplexParam> complexParams = queryParam.getComplexParams();
		if(!ListUtil.isEmpty(complexParams)){
			complexParams.forEach(c->{
				if(ComplexParam.AND.equals(c.getLogic())){
					queryWrapper.and(w-> setWrapper(w,c));
				}else {
					queryWrapper.or(w-> setWrapper(w,c));
				}
			});
		}
		/** 设置整体排序方式 */
		LinkedHashMap<String,String> orderMap = queryParam.getOrderMap();
		for(String key : orderMap.keySet()){
			String value = orderMap.get(key);
			if(QueryParam.ASC.equals(value.toLowerCase())){
				queryWrapper.orderByAsc(CamelAndUnderLineConverter.humpToLine(key));
			}else if(QueryParam.DESC.equals(value.toLowerCase())){
				queryWrapper.orderByDesc(CamelAndUnderLineConverter.humpToLine(key));
			}
		}
		return queryWrapper;
	}

	/**
	 * 校验SqlKey是否非法
	 * \\b  表示 限定单词边界
	 * 比如  select 不通过   1select则是可以的
	 * */
	private static String reg = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(from|concat|updatexml|select|update|union|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|drop|execute)\\b)";
	private static Pattern sqlPattern= Pattern.compile(reg, Pattern.CASE_INSENSITIVE);
	private static boolean  isValidKey(String key){
		if (sqlPattern.matcher(key).find()){
			return false;
		}
		return true;
	}

	public static void main(String[] args) {
		System.out.println(isValidKey("delete * from -- "));
	}
}
