package com.ejianc.framework.skeleton.template.es;

import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 
 * ES的dao接口偷懒，就直接复用了苞米豆的了,  只查询封装
 * 
 * @author guominga 2020-02-15
 */
public interface IBaseEsQueryDao<T> {

    /**
     * 根据 参数map 条件，查询总记录数
     *
     * @param queryParam 查询参数
     */
    Long selectCount(QueryParam queryParam);

    /**
     * 根据 parammap 条件，查询全部记录
     *
     * @param queryParam 查询参数
     */
    List<T> selectList(QueryParam queryParam);

    /**
     * 根据 entity 条件，查询全部记录（并翻页）
     *
     * @param page         分页查询条件（可以为 RowBounds.DEFAULT）
     * @param queryParam  查询参数
     */
    IPage<T> selectPage(IPage<T> page, QueryParam queryParam);
}
