/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.billState.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.mapper.CommonUpdateBillStateMapper;
import com.ejianc.framework.skeleton.billState.param.QueryBillDetailParam;
import com.ejianc.framework.skeleton.billState.param.QueryQuoteParam;
import com.ejianc.framework.skeleton.billState.param.UpdateBillStateParam;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;
import com.ejianc.framework.skeleton.extdata.bean.CustomBusinessDataEntity;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CommonUpdateBillStateServiceImpl
implements CommonUpdateBillStateService {
    private static final Logger Log = LoggerFactory.getLogger(CommonUpdateBillStateServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${extend.field.mode:false}")
    private Boolean extFieldsMode;
    @Autowired
    private ICustomBusinessDataService customBusinessDataService;
    @Autowired
    private CommonUpdateBillStateMapper mapper;
    @Autowired
    private IMdAttributeApi mdAttributeApi;

    @Override
    public CommonResponse<String> updateBillState(UpdateBillStateParam updateBillStateParam) {
        Log.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u5f00\u59cb---------------------\u5c06\u5355\u636e\uff1a" + updateBillStateParam.getBillId() + "\u7684billState\u4fee\u6539\u4e3a" + updateBillStateParam.getBillState() + "");
        String billState = this.mapper.queryBillState(updateBillStateParam);
        this.mapper.updateBillState(updateBillStateParam);
        Log.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u6210\u529f---------------------\u5c06\u8868\uff1a" + updateBillStateParam.getTableName() + "\u4e2d\u7684\u5355\u636e\uff1a" + updateBillStateParam.getBillId() + "\u7684billState\u4fee\u6539\u4e3a" + updateBillStateParam.getBillState() + "");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)billState);
    }

    @Override
    public JSONObject queryBillDetail(QueryBillDetailParam queryBillDetailParam) {
        CommonResponse attributeResponse;
        List<String> columnList = this.mapper.queryTableAttrList(queryBillDetailParam.getTableName());
        HashMap<String, String> columnMap = new HashMap<String, String>();
        if (columnList != null && columnList.size() > 0) {
            for (String column : columnList) {
                columnMap.put(column, column);
            }
        }
        if ((attributeResponse = this.mdAttributeApi.queryMainAttributeList(Long.valueOf(Long.parseLong(queryBillDetailParam.getMetadataId())))).isSuccess()) {
            List mdAttributeVos = (List)attributeResponse.getData();
            ArrayList<MdAttributeVO> customAttributeVos = new ArrayList<MdAttributeVO>();
            StringBuffer paramBuffer = new StringBuffer("");
            if (mdAttributeVos != null && mdAttributeVos.size() > 0) {
                for (MdAttributeVO mdAttributeVo : mdAttributeVos) {
                    if (columnMap.containsKey(mdAttributeVo.getColumnName())) {
                        paramBuffer.append(mdAttributeVo.getColumnName()).append(" as ").append(mdAttributeVo.getAttributeName()).append(",");
                    }
                    if (!"custom".equals(mdAttributeVo.getDescription())) continue;
                    customAttributeVos.add(mdAttributeVo);
                }
                if (StringUtils.isNotBlank((CharSequence)paramBuffer)) {
                    String parameter = paramBuffer.substring(0, paramBuffer.length() - 1);
                    JSONObject jsonObject = this.mapper.queryBillDetail(queryBillDetailParam.getTableName(), parameter, queryBillDetailParam.getBillId());
                    if (this.extFieldsMode.booleanValue()) {
                        QueryParam param = new QueryParam();
                        param.getParams().put("businessId", new Parameter("eq", (Object)queryBillDetailParam.getBillId()));
                        try {
                            List dataEntities = this.customBusinessDataService.queryList(param);
                            if (ListUtil.isNotEmpty(dataEntities)) {
                                CustomBusinessDataEntity dataEntity = (CustomBusinessDataEntity)dataEntities.get(0);
                                JSONObject map = JSONObject.parseObject((String)dataEntity.getBusinessData());
                                Log.info("\u5ba1\u6279\u67e5\u8be2\u5355\u636e" + queryBillDetailParam.getBillId() + "\u7684\u6269\u5c55\u6570\u636e\u4e3a\uff1a" + JSONObject.toJSONString((Object)map));
                                if (map != null) {
                                    for (MdAttributeVO attributeVO : customAttributeVos) {
                                        if (!Objects.nonNull(map.get((Object)attributeVO.getAttributeName()))) continue;
                                        switch (attributeVO.getCustomDataType()) {
                                            case "input": 
                                            case "date": 
                                            case "number": 
                                            case "currency": 
                                            case "textarea": {
                                                break;
                                            }
                                            case "select": 
                                            case "radiogroup": {
                                                map.put(attributeVO.getAttributeName(), (Object)JSONObject.parseObject((String)map.get((Object)attributeVO.getAttributeName()).toString()).getString("text"));
                                                break;
                                            }
                                            case "switch": {
                                                map.put(attributeVO.getAttributeName(), (Object)("true".equals(map.get((Object)attributeVO.getAttributeName())) ? "\u5f00" : "\u5173"));
                                                break;
                                            }
                                            case "enumselect": 
                                            case "inputrefer": {
                                                map.put(attributeVO.getAttributeName(), (Object)JSONObject.parseObject((String)map.get((Object)attributeVO.getAttributeName()).toString()).getString("name"));
                                            }
                                        }
                                    }
                                    jsonObject.putAll((Map)map);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.logger.warn("\u6269\u5c55\u6570\u636e\u5b58\u50a8\u6216\u8bfb\u53d6\u5931\u8d25\uff0c \u5982\u679c\u6709\u4f7f\u7528\u6269\u5c55\u5b57\u6bb5\uff0c\u8bf7\u5728\u60a8\u7684\u5fae\u670d\u52a1\u6570\u636e\u5e93\u4e2d\u5efa\u7acbejc_custom_businessdata\u8868");
                        }
                    }
                    Log.info("\u5ba1\u6279\u67e5\u8be2\u5355\u636e" + queryBillDetailParam.getBillId() + "\u7684\u6570\u636e\u4e3a\uff1a" + jsonObject.toJSONString());
                    return jsonObject;
                }
            }
        }
        return null;
    }

    @Override
    public String queryQuoteById(QueryQuoteParam queryQuoteParam) {
        String count = this.mapper.queryQuoteById(queryQuoteParam.getBillId(), queryQuoteParam.getTableName(), queryQuoteParam.getColumn(), InvocationInfoProxy.getTenantid());
        return count;
    }
}

