/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.template.es;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.ejianc.framework.skeleton.template.es.ESProperties;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class HighRestClientFactoryBean
implements FactoryBean<RestHighLevelClient>,
InitializingBean,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private RestHighLevelClient restHighLevelClient;
    private ESProperties esProperties;

    public void setEsProperties(ESProperties esProperties) {
        this.esProperties = esProperties;
    }

    public void destroy() throws Exception {
        try {
            this.log.info("Closing elasticSearch  client");
            if (null != this.restHighLevelClient) {
                this.restHighLevelClient.close();
            }
        }
        catch (Exception e) {
            this.log.error("Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public boolean isSingleton() {
        return false;
    }

    public Class<?> getObjectType() {
        return RestHighLevelClient.class;
    }

    public RestHighLevelClient getObject() throws Exception {
        return this.restHighLevelClient;
    }

    public void afterPropertiesSet() throws Exception {
        this.createClient();
    }

    private void createClient() throws Exception {
        String clusterNodes = this.esProperties.getClusterNodes();
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])this.getHttpHosts(clusterNodes));
        restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
            BasicCredentialsProvider cp = new BasicCredentialsProvider();
            if (StringUtils.isNotBlank((CharSequence)this.esProperties.getUsername()) && StringUtils.isNotBlank((CharSequence)this.esProperties.getPassword())) {
                cp.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.esProperties.getUsername(), this.esProperties.getPassword()));
            }
            if (null != this.esProperties.getThreadCount()) {
                httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(this.esProperties.getThreadCount().intValue()).build());
            }
            httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)cp);
            return httpAsyncClientBuilder;
        });
        restClientBuilder.setRequestConfigCallback(requestConfigCallback -> {
            if (null != this.esProperties.getConnectTimeout()) {
                requestConfigCallback.setConnectTimeout(this.esProperties.getConnectTimeout().intValue());
            }
            if (null != this.esProperties.getSocketTimeout()) {
                requestConfigCallback.setSocketTimeout(this.esProperties.getSocketTimeout().intValue());
            }
            if (null != this.esProperties.getConnectionRequestTimeout()) {
                requestConfigCallback.setConnectionRequestTimeout(this.esProperties.getConnectionRequestTimeout().intValue());
            }
            return requestConfigCallback;
        });
        this.restHighLevelClient = new RestHighLevelClient(restClientBuilder);
    }

    public HttpHost[] getHttpHosts(String clusterNodes) {
        Assert.hasText((String)clusterNodes, (String)"Cluster nodes source must not be null or empty!");
        String[] nodes = StrUtil.split((CharSequence)clusterNodes, (CharSequence)",");
        List httpHosts = Arrays.stream(nodes).map(node -> {
            String[] hostAndPort = StrUtil.split((CharSequence)node, (CharSequence)":");
            Assert.isTrue((hostAndPort.length == 2 ? 1 : 0) != 0, () -> String.format("\u5728[%s]\u96c6\u7fa4\u8282\u70b9\u4e2d, node:[%s]\u5b58\u5728\u9519\u8bef ! \u683c\u5f0f\u5fc5\u987b\u662fhost:port!", clusterNodes, node));
            String host = hostAndPort[0].trim();
            String port = hostAndPort[1].trim();
            Assert.hasText((String)host, () -> String.format("\u5728node:[%s]\u6ca1\u627e\u5230host!", node));
            Assert.hasText((String)port, () -> String.format("\u5728node:[%s]\u6ca1\u627e\u5230port!", node));
            HttpHost httpHost = StrUtil.isNotBlank((CharSequence)this.esProperties.getScheme()) ? new HttpHost(host, Integer.parseInt(port), this.esProperties.getScheme()) : new HttpHost(host, Integer.parseInt(port));
            return httpHost;
        }).collect(Collectors.toList());
        return (HttpHost[])ArrayUtil.toArray(httpHosts, HttpHost.class);
    }
}

