/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.template.event;

import com.ejianc.framework.skeleton.template.event.YYJZEvent;
import com.ejianc.framework.skeleton.template.event.YYJZEventPublisher;
import com.ejianc.framework.skeleton.template.event.YYJZListener;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.ErrorHandler;

public class DefaultPublisher
implements YYJZEventPublisher {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    private final Set<YYJZListener<?>> listeners = new LinkedHashSet();
    private Executor taskExecutor;
    private ErrorHandler errorHandler;

    public Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public YYJZListener<?> addListener(YYJZListener<?> listener) {
        this.writeLock.lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
        return listener;
    }

    @Override
    public void removeListener(YYJZListener<?> listener) {
        this.writeLock.lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeAllListeners() {
        this.writeLock.lock();
        try {
            this.listeners.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void fireEvent(YYJZEvent event) {
        this.fireEvent(event, ResolvableType.forInstance((Object)event));
    }

    protected boolean supportsEvent(ApplicationListener<?> listener, ResolvableType eventType, @Nullable Class<?> sourceType) {
        GenericApplicationListener smartListener = listener instanceof GenericApplicationListener ? (GenericApplicationListener)listener : new GenericApplicationListenerAdapter(listener);
        return smartListener.supportsEventType(eventType) && smartListener.supportsSourceType(sourceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(YYJZEvent event, @Nullable ResolvableType eventType) {
        this.readLock.lock();
        try {
            ResolvableType type = eventType != null ? eventType : ResolvableType.forInstance((Object)event);
            for (YYJZListener<?> listener : this.listeners) {
                Executor executor = this.getTaskExecutor();
                if (executor != null) {
                    executor.execute(() -> this.invokeListener(listener, event));
                    continue;
                }
                this.invokeListener(listener, event);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void invokeListener(YYJZListener<?> listener, YYJZEvent event) {
        ErrorHandler errorHandler = this.getErrorHandler();
        if (errorHandler != null) {
            try {
                this.doInvokeListener(listener, event);
            }
            catch (Throwable err) {
                errorHandler.handleError(err);
            }
        } else {
            this.doInvokeListener(listener, event);
        }
    }

    private void doInvokeListener(YYJZListener listener, YYJZEvent event) {
        try {
            listener.onEvent(event);
        }
        catch (ClassCastException ex) {
            String msg = ex.getMessage();
            if (msg == null || this.matchesClassCastMessage(msg, event.getClass().getName())) {
                Log logger = LogFactory.getLog(this.getClass());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Non-matching event type for listener: " + listener), (Throwable)ex);
                }
            }
            throw ex;
        }
    }

    private boolean matchesClassCastMessage(String classCastMessage, String eventClassName) {
        if (classCastMessage.startsWith(eventClassName)) {
            return true;
        }
        int moduleSeparatorIndex = classCastMessage.indexOf(47);
        return moduleSeparatorIndex != -1 && classCastMessage.startsWith(eventClassName, moduleSeparatorIndex + 1);
    }
}

