/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QRCodeUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer WIDTH = 150;
    private static final Integer HEIGHT = 150;
    private static final Integer LOGO_WIDTH = 22;
    private static final Integer LOGO_HEIGHT = 22;
    private static final String IMAGE_FORMAT = "png";
    private static final String CHARSET = "utf-8";
    private static final String BASE64_IMAGE = "data:image/png;base64,%s";

    public String getBase64QRCode(String content) {
        return this.getBase64Image(content, WIDTH, HEIGHT, null, null, null);
    }

    public String getBase64QRCode(String content, String logoUrl) {
        return this.getBase64Image(content, WIDTH, HEIGHT, logoUrl, LOGO_WIDTH, LOGO_HEIGHT);
    }

    public String getBase64QRCode(String content, Integer width, Integer height, String logoUrl, Integer logoWidth, Integer logoHeight) {
        return this.getBase64Image(content, width, height, logoUrl, logoWidth, logoHeight);
    }

    private String getBase64Image(String content, Integer width, Integer height, String logoUrl, Integer logoWidth, Integer logoHeight) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedImage bufferedImage = this.crateQRCode(content, width, height, logoUrl, logoWidth, logoHeight);
        try {
            ImageIO.write((RenderedImage)bufferedImage, IMAGE_FORMAT, os);
        }
        catch (IOException e) {
            this.logger.error("[\u751f\u6210\u4e8c\u7ef4\u7801\uff0c\u9519\u8bef{}]", (Throwable)e);
            e.printStackTrace();
        }
        return String.format(BASE64_IMAGE, Base64.encode((byte[])os.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage crateQRCode(String content, Integer width, Integer height, String logoUrl, Integer logoWidth, Integer logoHeight) {
        if (StrUtil.isNotBlank((CharSequence)content)) {
            Object stream = null;
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(4);
            hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            hints.put(EncodeHintType.MARGIN, 2);
            try {
                QRCodeWriter writer = new QRCodeWriter();
                BitMatrix bitMatrix = writer.encode(content, BarcodeFormat.QR_CODE, width.intValue(), height.intValue(), hints);
                BufferedImage bufferedImage = new BufferedImage(width, height, 1);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        bufferedImage.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
                    }
                }
                if (StrUtil.isNotBlank((CharSequence)logoUrl)) {
                    this.insertLogo(bufferedImage, width, height, logoUrl, logoWidth, logoHeight);
                }
                BufferedImage bufferedImage2 = bufferedImage;
                return bufferedImage2;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    try {
                        stream.flush();
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private void insertLogo(BufferedImage source, Integer width, Integer height, String logoUrl, Integer logoWidth, Integer logoHeight) throws Exception {
        BufferedImage src = ImageIO.read(new URL(logoUrl));
        Graphics2D graph = source.createGraphics();
        int x = (width - logoWidth) / 2;
        int y = (height - logoHeight) / 2;
        graph.drawImage(src, x, y, logoWidth, logoHeight, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, logoWidth.intValue(), logoHeight.intValue(), 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }

    public void getQRCode(String content, OutputStream output) throws IOException {
        BufferedImage image = this.crateQRCode(content, WIDTH, HEIGHT, null, null, null);
        ImageIO.write((RenderedImage)image, IMAGE_FORMAT, output);
    }

    public void getQRCode(String content, String logoUrl, OutputStream output) throws Exception {
        BufferedImage image = this.crateQRCode(content, WIDTH, HEIGHT, logoUrl, LOGO_WIDTH, LOGO_HEIGHT);
        ImageIO.write((RenderedImage)image, IMAGE_FORMAT, output);
    }
}

