package com.ejianc.framework.skeleton.billState.controller;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.QueryBillDetailParam;
import com.ejianc.framework.skeleton.billState.param.QueryQuoteParam;
import com.ejianc.framework.skeleton.billState.param.UpdateBillStateParam;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;


/**  
  * updateBillState公共服务
  * 
  * @author liyongjia  
  * @date 2020年5月14日  
  */
@Controller
@RequestMapping(value = "commonstate")
public class CommonUpdateBillStateController {
	private final static org.slf4j.Logger logger = LoggerFactory.getLogger(CommonUpdateBillStateController.class);

	@Autowired
	private CommonUpdateBillStateService commonUpdateBillStateService;

	@RequestMapping(value = "updateBillState", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> updateBillState(@RequestBody UpdateBillStateParam  updateBillStateParam) {		
		if(updateBillStateParam.getBillId()==null || updateBillStateParam.getBillId() == 0){
			logger.error("单据id不能为空");
			return CommonResponse.error("单据id不能为空");
		}
		if(StringUtils.isBlank(updateBillStateParam.getTableName())){
			logger.error("业务表名称为空");
			return CommonResponse.error("业务表名称不能为空");
		}
		if(updateBillStateParam.getBillState() == null){
			logger.error("单据状态不能为空");
			return CommonResponse.error("单据状态不能为空");
		}
		return commonUpdateBillStateService.updateBillState(updateBillStateParam);
	}
	
	@RequestMapping(value = "queryBillDetail", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryBillDetail(@RequestBody QueryBillDetailParam queryBillDetailParam) {
		if(StringUtils.isBlank(queryBillDetailParam.getBillId())) {
			logger.error("单据ID不能为空！");
			return CommonResponse.error("单据ID不能为空");
		}
		if(StringUtils.isBlank(queryBillDetailParam.getTableName())) {
			logger.error("业务表名不能为空！");
			return CommonResponse.error("业务表名称不能为空");
		}
		if(StringUtils.isBlank(queryBillDetailParam.getMetadataId())) {
			logger.error("单据元数据ID不能为空！");
			return CommonResponse.error("单据元数据ID不能为空");
		}
		JSONObject jsonObject =  commonUpdateBillStateService.queryBillDetail(queryBillDetailParam);
		return CommonResponse.success(jsonObject);
	}
	
	@RequestMapping(value = "queryBillCount", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Long> queryBillCount(@RequestBody QueryBillDetailParam queryBillDetailParam) {
		if(StringUtils.isBlank(queryBillDetailParam.getTableName())) {
			logger.error("业务表名不能为空！");
			return CommonResponse.error("业务表名称不能为空");
		}
		Long dataCount =  commonUpdateBillStateService.queryBillCount(queryBillDetailParam);
		return CommonResponse.success(dataCount);
	}
	
	@RequestMapping(value = "queryQuoteById", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> queryQuoteById(@RequestBody QueryQuoteParam queryQuoteParam) {
		if(StringUtils.isBlank(queryQuoteParam.getBillId())) {
			logger.error("单据ID不能为空！");
			return CommonResponse.error("单据ID不能为空");
		}
		if(StringUtils.isBlank(queryQuoteParam.getTableName())) {
			logger.error("业务表名不能为空！");
			return CommonResponse.error("业务表名称不能为空");
		}
		if(StringUtils.isBlank(queryQuoteParam.getColumn())) {
			logger.error("列名不能为空！");
			return CommonResponse.error("列名不能为空");
		}
		String count =  commonUpdateBillStateService.queryQuoteById(queryQuoteParam);
		return CommonResponse.success("查询成功",count);
	}
	
}
