package com.ejianc.framework.skeleton.billState.service.impl;

import java.util.*;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.extdata.bean.CustomBusinessDataEntity;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.mapper.CommonUpdateBillStateMapper;
import com.ejianc.framework.skeleton.billState.param.QueryBillDetailParam;
import com.ejianc.framework.skeleton.billState.param.QueryQuoteParam;
import com.ejianc.framework.skeleton.billState.param.UpdateBillStateParam;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;

/**  
  * Title: CommonUpdateBillStateServiceImpl  
  * Description: 
  * @author liyongjia  
  * @date 2020-05-14    
  */
@Service
public class CommonUpdateBillStateServiceImpl implements CommonUpdateBillStateService {
	private final static org.slf4j.Logger Log = LoggerFactory.getLogger(CommonUpdateBillStateServiceImpl.class);
	private final Logger logger = LoggerFactory.getLogger(getClass());
	@Value("${extend.field.mode:false}")
	private Boolean extFieldsMode;
	@Autowired
	private ICustomBusinessDataService customBusinessDataService;

	@Autowired
	private CommonUpdateBillStateMapper mapper;
	@Autowired
	private IMdAttributeApi mdAttributeApi;
	
	@Override
	public CommonResponse<String> updateBillState(UpdateBillStateParam updateBillStateParam) {
		Log.info("修改单据状态开始---------------------将单据："+updateBillStateParam.getBillId()+"的billState修改为"+updateBillStateParam.getBillState()+"");
		//先查询下单据之前的状态
		String billState = mapper.queryBillState(updateBillStateParam);
		//修改单据状态
		mapper.updateBillState(updateBillStateParam);
		Log.info("修改单据状态成功---------------------将表："+updateBillStateParam.getTableName() +"中的单据："+updateBillStateParam.getBillId()+"的billState修改为"+updateBillStateParam.getBillState()+"");
		return CommonResponse.success("查询成功", billState);
		
	}

	@Override
	public JSONObject queryBillDetail(QueryBillDetailParam queryBillDetailParam) {
		//查询元数据表结构
		List<String> columnList = mapper.queryTableAttrList(queryBillDetailParam.getTableName());
		Map<String, String> columnMap = new HashMap<String, String>();
		if(columnList != null && columnList.size() > 0) {
			for(String column:columnList) {
				columnMap.put(column, column);
			}
		}
		CommonResponse<List<MdAttributeVO>> attributeResponse = mdAttributeApi.queryMainAttributeList(Long.parseLong(queryBillDetailParam.getMetadataId()));
		if(attributeResponse.isSuccess()) {
			List<MdAttributeVO> mdAttributeVos = attributeResponse.getData();
			List<MdAttributeVO> customAttributeVos = new ArrayList<>();
			StringBuffer paramBuffer = new StringBuffer("");
			if(mdAttributeVos != null && mdAttributeVos.size() > 0) {
				for(MdAttributeVO mdAttributeVo:mdAttributeVos) {
					if(columnMap.containsKey(mdAttributeVo.getColumnName())) {
						paramBuffer.append(mdAttributeVo.getColumnName()).append(" as ").append(mdAttributeVo.getAttributeName()).append(",");
					}
					if("custom".equals(mdAttributeVo.getDescription())){
						customAttributeVos.add(mdAttributeVo);
					}
				}
				if(StringUtils.isNotBlank(paramBuffer)) {
					String parameter = paramBuffer.substring(0, paramBuffer.length() - 1);
					JSONObject jsonObject = mapper.queryBillDetail(queryBillDetailParam.getTableName(), parameter, queryBillDetailParam.getBillId());
					if(extFieldsMode){
						QueryParam param = new QueryParam();
						param.getParams().put("businessId",new Parameter(QueryParam.EQ,queryBillDetailParam.getBillId()));
						try {
						List<CustomBusinessDataEntity> dataEntities = customBusinessDataService.queryList(param);
						if(ListUtil.isNotEmpty(dataEntities)){
							CustomBusinessDataEntity dataEntity = dataEntities.get(0);//取第一个
							JSONObject map = JSONObject.parseObject(dataEntity.getBusinessData());
							Log.info("审批查询单据"+queryBillDetailParam.getBillId()+"的扩展数据为："+JSONObject.toJSONString(map));
							if(map!=null){
								for (MdAttributeVO attributeVO : customAttributeVos) {
									if(Objects.nonNull(map.get(attributeVO.getAttributeName()))){
										switch (attributeVO.getCustomDataType()){
											case "input":
											case "date":
											case "number":
											case "currency":
											case "textarea":
												break;
											case "select":
											case "radiogroup":
												map.put(attributeVO.getAttributeName(),JSONObject.parseObject(map.get(attributeVO.getAttributeName()).toString()).getString("text"));
												break;
											case "switch":
												map.put(attributeVO.getAttributeName(),"true".equals(map.get(attributeVO.getAttributeName()))?"开":"关");
												break;
											case "enumselect":
											case "inputrefer":
												map.put(attributeVO.getAttributeName(),JSONObject.parseObject(map.get(attributeVO.getAttributeName()).toString()).getString("name"));
												break;
										}
									}
								}

								jsonObject.putAll(map);
							}
						}
						} catch (Exception e) {
							logger.warn("扩展数据存储或读取失败， 如果有使用扩展字段，请在您的微服务数据库中建立ejc_custom_businessdata表");
						}
					}
					Log.info("审批查询单据"+queryBillDetailParam.getBillId()+"的数据为："+jsonObject.toJSONString());
					return jsonObject;
				}
			}
		}
		return null;
	}

	@Override
	public String queryQuoteById(QueryQuoteParam queryQuoteParam) {
		String count = mapper.queryQuoteById(queryQuoteParam.getBillId(),queryQuoteParam.getTableName(),queryQuoteParam.getColumn(), InvocationInfoProxy.getTenantid());
		return count;
	}

	@Override
	public Long queryBillCount(QueryBillDetailParam queryBillDetailParam) {
		Long billCount = mapper.queryBillCount(queryBillDetailParam);
		return billCount;
	}
	
}
