package com.ejianc.framework.skeleton.template;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.springframework.data.redis.core.RedisTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * author: caojie
 */
@SuppressWarnings({ "unchecked", "unused" })
public class BaseVO implements Serializable {

	private static final long serialVersionUID = -6550871832456894273L;
	private static final String REFER_CACHE_KEY = "refer_cache_key:";

	public static final Integer DR_UNDELETE = 0;
	public static final Integer DR_DELETED = 1;

	/**
	 * 主键ID
	 */
	private Long id;
	/**
	 * 创建者账号
	 */
	private String createUserCode;
	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date createTime;
	/**
	 * 修改者账号
	 */
	private String updateUserCode;
	/**
	 * 修改时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date updateTime;
	/**
	 * 删除标识（0：未删， 1：删除）
	 */
	private Integer dr;
	/**
	 * 租户ID
	 */
	private Long tenantId;
	/**
	 * 是否同步es
	 */
	private String syncEsFlag;

	private String rowState;

	/**
	 * 附件ids
	 */
	private List<Long> attachIds = new ArrayList<>();

	private Integer version;

	private String createUserName;

	private String updateUserName;

	private Map<String, Object> customField;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getCreateUserCode() {
//		if((StringUtils.isNotBlank(createUserCode) && createUserCode.startsWith("admin")) || "guoming".equals(createUserCode)) {
//			createUserCode = null;
//		}
		return createUserCode;
	}

	public void setCreateUserCode(String createUserCode) {
		this.createUserCode = createUserCode;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getUpdateUserCode() {
//		if((StringUtils.isNotBlank(updateUserCode) && updateUserCode.startsWith("admin")) || "guoming".equals(updateUserCode)) {
//			updateUserCode = null;
//		}
		return updateUserCode;
	}

	public void setUpdateUserCode(String updateUserCode) {
		this.updateUserCode = updateUserCode;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	public Integer getDr() {
		return dr;
	}

	public void setDr(Integer dr) {
		this.dr = dr;
	}

	public Long getTenantId() {
		return tenantId;
	}

	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}

	public String getSyncEsFlag() {
		return syncEsFlag;
	}

	public void setSyncEsFlag(String syncEsFlag) {
		this.syncEsFlag = syncEsFlag;
	}

	public String getRowState() {
		return rowState;
	}

	public void setRowState(String rowState) {
		this.rowState = rowState;
	}

	public List<Long> getAttachIds() {
		return attachIds;
	}

	public void setAttachIds(List<Long> attachIds) {
		this.attachIds = attachIds;
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public Map<String, Object> getCustomField() {
		return customField;
	}

	public void setCustomField(Map<String, Object> customField) {
		this.customField = customField;
	}

	public String getCreateUserName() {
		try {
			MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
			if (StringUtils.isNotBlank(getCreateUserCode()) && StringUtils.isNotBlank(urlconstants.getBaseHost()) && !(
					createUserCode.startsWith("admin") || "guoming".equals(createUserCode)) ) {
				String cacheKey = REFER_CACHE_KEY + "idm-employee:" + getCreateUserCode();
				RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);

				Object cacheValue = redisTemplate.opsForValue().get(cacheKey);

				JSONObject jsonObject = null;
				if (cacheValue != null) {
					jsonObject = JSON.parseObject(cacheValue.toString());
				} else {
					String referData = getReferRestUrl("idm-employee");
					JSONObject json = JSON.parseObject(referData);
					String referUrl = json.get("projectName").toString();
					Map<String, Object> reflist = new HashMap<>();
					reflist = (Map<String, Object>) json.get("refMapList");
					reflist.put("userCode", getCreateUserCode());
					String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
					String jsonbackstr = null;
					try {
						jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
					} catch (Exception e) {
					}
					if (StringUtils.isNotBlank(jsonbackstr)) {
						jsonObject = JSON.parseObject(jsonbackstr);
						redisTemplate.opsForValue().set(cacheKey, jsonbackstr, 1, TimeUnit.DAYS);
					}else{
						redisTemplate.opsForValue().set(cacheKey, getCreateUserCode(), 10, TimeUnit.MINUTES);
					}
				}
				if (jsonObject != null) {
					return jsonObject.getString("userName");
				}
			}
		} catch (Exception e) {
		}
		return getCreateUserCode();
	}

	public String getUpdateUserName() {
		try {
			MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
			if (StringUtils.isNotBlank(getUpdateUserCode()) && StringUtils.isNotBlank(urlconstants.getBaseHost()) && !(
					updateUserCode.startsWith("admin") || "guoming".equals(updateUserCode)) ) {
				String cacheKey = REFER_CACHE_KEY + "idm-employee:" + getUpdateUserCode();
				RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);

				Object cacheValue = redisTemplate.opsForValue().get(cacheKey);

				JSONObject jsonObject = null;
				if (cacheValue != null) {
					jsonObject = JSON.parseObject(cacheValue.toString());
				} else {
					String referData = getReferRestUrl("idm-employee");
					JSONObject json = JSON.parseObject(referData);
					String referUrl = json.get("projectName").toString();
					Map<String, Object> reflist = new HashMap<>();
					reflist = (Map<String, Object>) json.get("refMapList");
					reflist.put("userCode", getUpdateUserCode());
					String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
					String jsonbackstr = null;
					try {
						jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
					} catch (Exception e) {
					}
					if (StringUtils.isNotBlank(jsonbackstr)) {
						jsonObject = JSON.parseObject(jsonbackstr);
						redisTemplate.opsForValue().set(cacheKey, jsonbackstr, 1, TimeUnit.DAYS);
					}else{
						redisTemplate.opsForValue().set(cacheKey, getUpdateUserCode(), 10, TimeUnit.MINUTES);
					}
				}
				if (jsonObject != null) {
					return jsonObject.getString("userName");
				}
			}
		} catch (Exception e) {
		}
		return getUpdateUserCode();
	}

	/**
	 * 通过元数据服务获取实体信息
	 * 
	 * @param className
	 * @return
	 */
	private static String getReferRestUrl(String referCode) {
		String data = null;
		MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
		String backData = null;
		try {
			backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, null);
		} catch (Exception e) {
		}

		JSONObject jsonobject = JSON.parseObject(backData);
		if (jsonobject.getString("code").equals("0")) {
			if (jsonobject.getString("data") != null) {
				data = JSON.parseObject(jsonobject.getString("data")).toJSONString();
			}
		} else {
			ExceptionUtil.wrappBusinessException("参照编码" + referCode + "的实体没有发布元数据!");
		}
		return data;

	}

}
