package com.ejianc.framework.skeleton.refer.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import com.ejianc.framework.skeleton.refer.serialize.ReferSerializer;
import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * 组合注解 将id转换成json{id:xx,code:xx,name:xx}
 * 
 * @author guominga
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@JacksonAnnotationsInside
@JsonSerialize(using = ReferSerializer.class)
public @interface ReferSerialTransfer {
	/**
	 * 转换实体对对应的引用code；
	 * 
	 * @return
	 */
	public String referCode() default "";
}
