package com.ejianc.framework.skeleton.billState.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.QueryBillDetailParam;
import com.ejianc.framework.skeleton.billState.param.QueryQuoteParam;
import com.ejianc.framework.skeleton.billState.param.UpdateBillStateParam;
import com.ejianc.framework.skeleton.billState.param.UpdateQuoteParam;

/**
 * 
 * @author liyongjia  2020-05-14
 *
 */
public interface CommonUpdateBillStateService {

	
	/**
	 * 修改单据状态
	 * 
	 * @param updateBillStateParam
	 * @return
	 */
	CommonResponse<String> updateBillState(UpdateBillStateParam updateBillStateParam);

	/**
	 * 查询单据详情
	 * 
	 * @param queryBillDetailParam
	 * @return
	 */
	JSONObject queryBillDetail(QueryBillDetailParam queryBillDetailParam);
	
	/**
	 * 查询单据总数
	 * 
	 * @param queryBillDetailParam
	 * @return
	 */
	Long queryBillCount(QueryBillDetailParam queryBillDetailParam);

	/**
	 * 查询单据是否被引用
	 * 
	 * @param queryQuoteParam
	 * @return
	 */
	String queryQuoteById(QueryQuoteParam queryQuoteParam);

	/**
	 * 更新引用信息
	 *
	 * @param updateQuoteParam
	 * @return
	 */
	void updateQuoteData(Long billId, String billTypeCode);

	void doUpdateQuoteData(UpdateQuoteParam updateQuoteParam);
}
