package com.ejianc.framework.skeleton.dataModel.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataModel.param.CommonDataModelParam;
import com.ejianc.framework.skeleton.dataModel.service.ICommonDataModelService;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 数据模型 公共服务
 * 
 * @author guoming
 */
@Controller
@RequestMapping(value = "common/data/model")
public class CommonDataModelController implements Serializable {

	private static final long serialVersionUID = 8227497523478327706L;
	
	@Autowired
	private ICommonDataModelService commonDataModelService;
	
	@RequestMapping(value = "parse", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<JSONObject>> parse(@RequestBody CommonDataModelParam dataModelParam) {
		String sqlContent = dataModelParam.getSqlContent();
		sqlContent = JdkBase64Util.decode(sqlContent);
		if(StringUtils.isNotBlank(sqlContent)) {
			if(sqlContent.toLowerCase().indexOf("insert") != -1 || sqlContent.toLowerCase().indexOf("update") != -1 || sqlContent.toLowerCase().indexOf("delete") != -1) {
				throw new BusinessException("执行sql中不允许含有insert、update、delete关键字。");
			}
		}
		List<JSONObject> resultList = commonDataModelService.queryDataModelList(sqlContent, dataModelParam.getDatasetType(), dataModelParam.getParams());
		return CommonResponse.success(resultList);
	}
}
