/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ServiceImpl<M extends BaseMapper<T>, T>
implements IService<T> {
    @Autowired
    protected M baseMapper;

    public M getBaseMapper() {
        return this.baseMapper;
    }

    protected boolean retBool(Integer result) {
        return SqlHelper.retBool((Integer)result);
    }

    protected Class<T> currentModelClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), (int)1);
    }

    protected SqlSession sqlSessionBatch() {
        return SqlHelper.sqlSessionBatch(this.currentModelClass());
    }

    protected void closeSqlSession(SqlSession sqlSession) {
        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(this.currentModelClass()));
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.table(this.currentModelClass()).getSqlStatement(sqlMethod.getMethod());
    }

    public boolean save(T entity) {
        return this.retBool(this.baseMapper.insert(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.sqlStatement(SqlMethod.INSERT_ONE);
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int i = 0;
            for (T anEntityList : entityList) {
                batchSqlSession.insert(sqlStatement, anEntityList);
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        return true;
    }

    private Boolean compareBean(T source, T target, TableInfo tableInfo) {
        boolean compareFlag = true;
        List fieldList = tableInfo.getFieldList();
        Class<T> cls = this.currentModelClass();
        if (fieldList != null && fieldList.size() > 0) {
            for (TableFieldInfo tableFieldInfo : fieldList) {
                Class clazz = tableFieldInfo.getPropertyType();
                String keyProperty = tableFieldInfo.getProperty();
                Boolean isPublicProperty = false;
                switch (keyProperty) {
                    case "createUserCode": {
                        isPublicProperty = true;
                        break;
                    }
                    case "createTime": {
                        isPublicProperty = true;
                        break;
                    }
                    case "updateUserCode": {
                        isPublicProperty = true;
                        break;
                    }
                    case "updateTime": {
                        isPublicProperty = true;
                        break;
                    }
                    case "dr": {
                        isPublicProperty = true;
                        break;
                    }
                    case "syncEsFlag": {
                        isPublicProperty = true;
                        break;
                    }
                    case "version": {
                        isPublicProperty = true;
                    }
                }
                if (isPublicProperty.booleanValue()) continue;
                try {
                    Object sourceVal;
                    if (String.class.isAssignableFrom(clazz)) {
                        sourceVal = (String)ReflectionKit.getMethodValue(cls, source, (String)keyProperty);
                        String targetVal = (String)ReflectionKit.getMethodValue(cls, target, (String)keyProperty);
                        if (StringUtils.isNotBlank((String)sourceVal) && ((String)sourceVal).equals(targetVal) || StringUtils.isBlank((String)sourceVal) && StringUtils.isBlank((String)targetVal)) continue;
                        compareFlag = false;
                        break;
                    }
                    if (Long.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
                        sourceVal = (Long)ReflectionKit.getMethodValue(cls, source, (String)keyProperty);
                        Long targetVal = (Long)ReflectionKit.getMethodValue(cls, target, (String)keyProperty);
                        if (sourceVal != null && ((Long)sourceVal).equals(targetVal) || sourceVal == null && targetVal == null) continue;
                        compareFlag = false;
                        break;
                    }
                    if (Integer.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
                        sourceVal = (Integer)ReflectionKit.getMethodValue(cls, source, (String)keyProperty);
                        Integer targetVal = (Integer)ReflectionKit.getMethodValue(cls, target, (String)keyProperty);
                        if (sourceVal != null && ((Integer)sourceVal).equals(targetVal) || sourceVal == null && targetVal == null) continue;
                        compareFlag = false;
                        break;
                    }
                    if (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
                        sourceVal = (Boolean)ReflectionKit.getMethodValue(cls, source, (String)keyProperty);
                        Boolean targetVal = (Boolean)ReflectionKit.getMethodValue(cls, target, (String)keyProperty);
                        if (sourceVal != null && ((Boolean)sourceVal).equals(targetVal)) continue;
                        compareFlag = false;
                        break;
                    }
                    if (BigDecimal.class.isAssignableFrom(clazz)) {
                        sourceVal = (BigDecimal)ReflectionKit.getMethodValue(cls, source, (String)keyProperty);
                        BigDecimal targetVal = (BigDecimal)ReflectionKit.getMethodValue(cls, target, (String)keyProperty);
                        if (sourceVal == null && targetVal == null || sourceVal != null && targetVal != null && ((BigDecimal)sourceVal).compareTo(targetVal) == 0) continue;
                        compareFlag = false;
                        break;
                    }
                    if (Date.class.isAssignableFrom(clazz)) {
                        sourceVal = (Date)ReflectionKit.getMethodValue(cls, source, (String)keyProperty);
                        Date targetVal = (Date)ReflectionKit.getMethodValue(cls, target, (String)keyProperty);
                        if (sourceVal == null && targetVal == null || sourceVal != null && targetVal != null && DateUtil.isSameTime((Date)sourceVal, (Date)targetVal)) continue;
                        compareFlag = false;
                        break;
                    }
                    compareFlag = false;
                }
                catch (Exception e) {
                    compareFlag = false;
                }
                break;
            }
        }
        return compareFlag;
    }

    private static String produce() {
        String result = "";
        try {
            SecureRandom srandom = SecureRandom.getInstance("SHA1PRNG");
            result = srandom.nextInt(1000) + "";
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (result.length() != 3) {
            return ServiceImpl.produce();
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdate(T entity) {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
            String keyProperty = tableInfo.getKeyProperty();
            Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
            Object idVal = ReflectionKit.getMethodValue(cls, entity, (String)tableInfo.getKeyProperty());
            Object targetEntity = null;
            if (!com.baomidou.mybatisplus.core.toolkit.StringUtils.checkValNull((Object)idVal)) {
                String rand = ServiceImpl.produce();
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"id", idVal);
                queryWrapper.eq((Object)"dr", (Object)0);
                queryWrapper.last(" and " + rand + "=" + rand + " ");
                targetEntity = this.baseMapper.selectOne((Wrapper)queryWrapper);
            }
            if (Objects.isNull(targetEntity)) {
                return this.save(entity);
            }
            if (!this.compareBean(entity, targetEntity, tableInfo).booleanValue()) {
                return this.updateById(entity);
            }
            return true;
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        Assert.notEmpty(entityList, (String)"error: entityList must not be empty", (Object[])new Object[0]);
        Class<T> cls = this.currentModelClass();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int i = 0;
            for (T entity : entityList) {
                Object idVal = ReflectionKit.getMethodValue(cls, entity, (String)keyProperty);
                Object targetEntity = null;
                if (!com.baomidou.mybatisplus.core.toolkit.StringUtils.checkValNull((Object)idVal)) {
                    String rand = ServiceImpl.produce();
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"id", idVal);
                    queryWrapper.eq((Object)"dr", (Object)0);
                    queryWrapper.last(" and " + rand + "=" + rand + " ");
                    targetEntity = this.baseMapper.selectOne((Wrapper)queryWrapper);
                }
                if (Objects.isNull(targetEntity)) {
                    batchSqlSession.insert(this.sqlStatement(SqlMethod.INSERT_ONE), entity);
                } else if (!this.compareBean(entity, targetEntity, tableInfo).booleanValue()) {
                    MapperMethod.ParamMap param = new MapperMethod.ParamMap();
                    param.put((Object)"et", entity);
                    batchSqlSession.update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), (Object)param);
                }
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        return true;
    }

    public boolean removeById(Serializable id) {
        return SqlHelper.delBool((Integer)this.baseMapper.deleteById(id));
    }

    public boolean removeByMap(Map<String, Object> columnMap) {
        Assert.notEmpty(columnMap, (String)"error: columnMap must not be empty", (Object[])new Object[0]);
        return SqlHelper.delBool((Integer)this.baseMapper.deleteByMap(columnMap));
    }

    public boolean remove(Wrapper<T> wrapper) {
        return SqlHelper.delBool((Integer)this.baseMapper.delete(wrapper));
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        return SqlHelper.delBool((Integer)this.baseMapper.deleteBatchIds(idList));
    }

    public boolean updateById(T entity) {
        return this.retBool(this.baseMapper.updateById(entity));
    }

    public boolean update(T entity, Wrapper<T> updateWrapper) {
        return this.retBool(this.baseMapper.update(entity, updateWrapper));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        Assert.notEmpty(entityList, (String)"error: entityList must not be empty", (Object[])new Object[0]);
        String sqlStatement = this.sqlStatement(SqlMethod.UPDATE_BY_ID);
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int i = 0;
            for (T anEntityList : entityList) {
                MapperMethod.ParamMap param = new MapperMethod.ParamMap();
                param.put((Object)"et", anEntityList);
                batchSqlSession.update(sqlStatement, (Object)param);
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        return true;
    }

    public T getById(Serializable id) {
        Object entity = this.baseMapper.selectById(id);
        return (T)entity;
    }

    public Collection<T> listByIds(Collection<? extends Serializable> idList) {
        return this.baseMapper.selectBatchIds(idList);
    }

    public Collection<T> listByMap(Map<String, Object> columnMap) {
        return this.baseMapper.selectByMap(columnMap);
    }

    public T getOne(Wrapper<T> queryWrapper, boolean throwEx) {
        if (throwEx) {
            return (T)this.baseMapper.selectOne(queryWrapper);
        }
        return (T)SqlHelper.getObject((List)this.baseMapper.selectList(queryWrapper));
    }

    public Map<String, Object> getMap(Wrapper<T> queryWrapper) {
        return (Map)SqlHelper.getObject((List)this.baseMapper.selectMaps(queryWrapper));
    }

    public int count(Wrapper<T> queryWrapper) {
        return SqlHelper.retCount((Integer)this.baseMapper.selectCount(queryWrapper));
    }

    public List<T> list(Wrapper<T> queryWrapper) {
        return this.baseMapper.selectList(queryWrapper);
    }

    public IPage<T> page(IPage<T> page, Wrapper<T> queryWrapper) {
        return this.baseMapper.selectPage(page, queryWrapper);
    }

    public List<Map<String, Object>> listMaps(Wrapper<T> queryWrapper) {
        return this.baseMapper.selectMaps(queryWrapper);
    }

    public <V> List<V> listObjs(Wrapper<T> queryWrapper, Function<? super Object, V> mapper) {
        return this.baseMapper.selectObjs(queryWrapper).stream().filter(Objects::nonNull).map(mapper).collect(Collectors.toList());
    }

    public IPage<Map<String, Object>> pageMaps(IPage<T> page, Wrapper<T> queryWrapper) {
        return this.baseMapper.selectMapsPage(page, queryWrapper);
    }
}

