/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.extdata.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.extdata.bean.CustomBusinessDataEntity;
import com.ejianc.framework.skeleton.extdata.mapper.CustomBusinessDataMapper;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomBusinessDataServiceImpl
extends BaseServiceImpl<CustomBusinessDataMapper, CustomBusinessDataEntity>
implements ICustomBusinessDataService {
    @Autowired
    private CustomBusinessDataMapper customBusinessDataMapper;

    @Override
    public CommonResponse<String> saveOrUpdateData(List<CustomBusinessDataVO> customBusinessDataVos) {
        if (customBusinessDataVos != null && customBusinessDataVos.size() > 0) {
            for (CustomBusinessDataVO customBusinessDataVo : customBusinessDataVos) {
                if (StringUtils.isBlank((CharSequence)customBusinessDataVo.getBusinessData())) {
                    this.customBusinessDataMapper.deleteByBusinessId(customBusinessDataVo.getBusinessId());
                    continue;
                }
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"business_id", (Object)customBusinessDataVo.getBusinessId());
                CustomBusinessDataEntity saveData = (CustomBusinessDataEntity)super.getOne((Wrapper)queryWrapper);
                if (saveData != null) {
                    saveData.setBusinessData(customBusinessDataVo.getBusinessData());
                } else {
                    saveData = new CustomBusinessDataEntity();
                    saveData.setId(IdWorker.getId());
                    saveData.setBusinessId(customBusinessDataVo.getBusinessId());
                    saveData.setBusinessData(customBusinessDataVo.getBusinessData());
                }
                super.saveOrUpdate(saveData, false);
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<Map<Long, CustomBusinessDataVO>> queryCustomBusinessData(List<Long> businessIdList) {
        if (businessIdList != null && businessIdList.size() > 0) {
            HashMap<Long, CustomBusinessDataVO> resultMap = new HashMap<Long, CustomBusinessDataVO>();
            for (Long businessId : businessIdList) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"business_id", (Object)businessId);
                CustomBusinessDataEntity saveData = (CustomBusinessDataEntity)super.getOne((Wrapper)queryWrapper);
                if (saveData == null || !StringUtils.isNotBlank((CharSequence)saveData.getBusinessData())) continue;
                CustomBusinessDataVO customBusinessDataVo = (CustomBusinessDataVO)BeanMapper.map((Object)saveData, CustomBusinessDataVO.class);
                resultMap.put(customBusinessDataVo.getBusinessId(), customBusinessDataVo);
            }
            return CommonResponse.success(resultMap);
        }
        return CommonResponse.error((String)"\u6269\u5c55\u6570\u636e\u4e3a\u7a7a");
    }

    @Override
    public CommonResponse<String> deleteCustomBusinessData(List<Long> businessIdList) {
        for (Long businessId : businessIdList) {
            this.customBusinessDataMapper.deleteByBusinessId(businessId);
        }
        return CommonResponse.success();
    }
}

