/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.fields.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.fields.controller.param.CostParameter;
import com.ejianc.framework.skeleton.fields.mapper.CommenQueryFieldsMapper;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommenQueryFieldsService
implements ICommenQueryFieldsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private CommenQueryFieldsMapper commenQueryFieldsMapper;
    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    public List<MdAttributeVO> queryFieldsByTableName(String tableName, String databaseName) {
        List<MdAttributeVO> list = this.commenQueryFieldsMapper.queryFieldsByTableName(tableName, databaseName);
        return list;
    }

    @Override
    public JSONObject queryBillDetail(String businessKey, String billTypeCode) {
        CommonResponse billTypeResponse = this.billTypeApi.queryMetadataByBillType(billTypeCode);
        if (billTypeResponse.isSuccess()) {
            MdReferVO referVo = (MdReferVO)billTypeResponse.getData();
            HashMap<String, String> paramterMap = new HashMap<String, String>();
            paramterMap.put("billId", String.valueOf(businessKey));
            paramterMap.put("tableName", referVo.getTableName());
            paramterMap.put("metadataId", referVo.getMetadataId().toString());
            this.logger.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u4f20\u9012\u7684\u53c2\u6570\uff1a---------------" + ((Object)paramterMap).toString());
            String paramterStr = this.gson.toJson(paramterMap);
            String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/commonstate/queryBillDetail";
            this.logger.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u4f20\u9012\u7684url\uff1a---------------" + url);
            try {
                String result = ReferHttpClientUtils.postByJson(url, paramterStr);
                this.logger.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (JSONObject)this.gson.fromJson(result, new TypeToken<JSONObject>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public JSONArray queryBillInfoByProperty(String databaseName, String tableName, String columns, String parameter) {
        return this.commenQueryFieldsMapper.queryBillInfoByProperty(databaseName, tableName, columns, parameter);
    }

    @Override
    public List<Map<String, Object>> queryBillList(String billTypeCode, String parameter, String condition) {
        CommonResponse billTypeResponse = this.billTypeApi.queryMetadataByBillType(billTypeCode);
        if (billTypeResponse.isSuccess()) {
            MdReferVO referVo = (MdReferVO)billTypeResponse.getData();
            HashMap<String, String> paramterMap = new HashMap<String, String>();
            paramterMap.put("parameter", parameter);
            paramterMap.put("tableName", referVo.getTableName());
            paramterMap.put("condition", condition);
            String paramterStr = this.gson.toJson(paramterMap);
            String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/commonFields/queryCostDatas";
            try {
                String result = ReferHttpClientUtils.postByJson(url, paramterStr);
                CommonResponse commonResponse = (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<List<Map<String, Object>>>>(){}.getType());
                if (commonResponse.isSuccess()) {
                    return (List)commonResponse.getData();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> queryCostDatas(CostParameter costParameter) {
        List<Map<String, Object>> costDatas = this.commenQueryFieldsMapper.queryCostDatas(costParameter.getParameter(), costParameter.getTableName(), costParameter.getCondition());
        return costDatas;
    }

    @Override
    public boolean updateProportionFlag(String billTypeCode, String billId, String proportionFlag) {
        CommonResponse billTypeResponse = this.billTypeApi.queryMetadataByBillType(billTypeCode);
        if (billTypeResponse.isSuccess()) {
            MdReferVO referVo = (MdReferVO)billTypeResponse.getData();
            HashMap<String, String> paramterMap = new HashMap<String, String>();
            paramterMap.put("billId", billId);
            paramterMap.put("tableName", referVo.getTableName());
            paramterMap.put("proportionFlag", proportionFlag);
            String paramterStr = this.gson.toJson(paramterMap);
            String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/commonFields/updateProportionFlag";
            try {
                String result = ReferHttpClientUtils.postByJson(url, paramterStr);
                CommonResponse commonResponse = (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
                if (commonResponse.isSuccess()) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public void updateProportionFlagDb(JSONObject jsonObject) {
        this.commenQueryFieldsMapper.updateProportionFlag(jsonObject.getString("billId"), jsonObject.getString("tableName"), jsonObject.getString("proportionFlag"));
    }
}

