/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.refer.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class ReferObjectUtil {
    private static final Logger Log = LoggerFactory.getLogger(ReferObjectUtil.class);
    private static final String REFER_CACHE_KEY = "refer_cache_key:";
    private static final String REFER_PROJECT_CACHE_KEY = "refer_project_cache_key:";

    public static JSONArray getReferEntityValue(String value, String referCode) throws Exception {
        RedisTemplate redisTemplate;
        Object cacheValue;
        MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
        JSONArray jsonArray = null;
        if (value.endsWith(",")) {
            value = value.substring(0, value.length() - 1);
        }
        String cacheKey = REFER_CACHE_KEY + referCode + ":" + value;
        if ("support-defdoc".equals(referCode)) {
            cacheKey = "refer_cache_key:-" + InvocationInfoProxy.getTenantid() + referCode + ":" + value;
        }
        if ((cacheValue = (redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class)).opsForValue().get((Object)cacheKey)) != null) {
            if (!"kongzhi".equals(cacheValue.toString())) {
                jsonArray = JSON.parseArray((String)cacheValue.toString());
            }
        } else {
            try {
                String referData = ReferObjectUtil.getReferRestUrl(referCode);
                JSONObject json = JSON.parseObject((String)referData);
                String referUrl = json.get((Object)"projectName").toString();
                Map reflist = (Map)json.get((Object)"refMapList");
                if (reflist == null) {
                    throw new BusinessException("\u53c2\u7167referCode\uff1a" + referCode + "\u6240\u5728\u53c2\u7167\u5143\u6570\u636e\u6ca1\u6709\u5b9a\u4e49\u53c2\u7167\u6620\u5c04\u5b57\u6bb5\uff0c\u8bf7\u5728\u5143\u6570\u636e\u4e2d\u5fc3\u8bbe\u7f6e");
                }
                reflist.put("valueId", value);
                reflist.put("databaseName", json.get((Object)"databaseName"));
                reflist.put("tableName", json.get((Object)"tableName"));
                String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getrefervalue";
                String jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
                jsonArray = JSON.parseArray((String)jsonbackstr);
                if (jsonArray.size() > 0) {
                    redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonbackstr, 10L, TimeUnit.MINUTES);
                } else {
                    jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
                    jsonArray = JSON.parseArray((String)jsonbackstr);
                    if (jsonArray.size() > 0) {
                        redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonbackstr, 10L, TimeUnit.MINUTES);
                    } else {
                        redisTemplate.opsForValue().set((Object)cacheKey, (Object)"kongzhi", 1L, TimeUnit.MINUTES);
                    }
                }
            }
            catch (Exception e) {
                Log.info("-----\u6709\u9519\u8bef------{}", (Throwable)e);
                redisTemplate.opsForValue().set((Object)cacheKey, (Object)"kongzhi", 1L, TimeUnit.MINUTES);
            }
        }
        return jsonArray;
    }

    private static String getReferRestUrl(String referCode) {
        RedisTemplate redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
        String cacheKey = REFER_PROJECT_CACHE_KEY + referCode;
        Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
        if (cacheValue != null) {
            return cacheValue.toString();
        }
        String data = null;
        MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;
        try {
            backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, null);
        }
        catch (ClientProtocolException e) {
            ExceptionUtil.wrappException((Exception)((Object)e));
        }
        catch (GeneralSecurityException e) {
            ExceptionUtil.wrappException(e);
        }
        catch (IOException e) {
            ExceptionUtil.wrappException(e);
        }
        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("code").equals("0")) {
            if (jsonobject.getString("data") != null) {
                data = JSON.parseObject((String)jsonobject.getString("data")).toJSONString();
                redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonobject.getString("data"), 24L, TimeUnit.HOURS);
            }
        } else {
            ExceptionUtil.wrappBusinessException("\u53c2\u7167\u7f16\u7801" + referCode + "\u7684\u5b9e\u4f53\u6ca1\u6709\u53d1\u5e03\u5143\u6570\u636e!");
        }
        return data;
    }
}

