package com.ejianc.framework.skeleton.refer.constants;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.Utils;

/**
 * support业务支撑组件
 * 
 * @author guominga  2020-02-20
 *
 */
@Component
public class MetaDataUrlconstants {
	
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	/**
	 * 元数据参照服务路径
	 */
	public final static String MetaData_GET_URL = "ejc-metadata-web/api/queryByRefCode?refCode=";

	@Value("${ejc.metadata.web.serverName}")
	private String metaDataBaseUrl;

	public String getMetaDataBaseUrl() {
		Long tenantid = InvocationInfoProxy.getTenantid();
		if(tenantid != null && tenantid > 0l) {
			String customerChannel = (String) redisTemplate.opsForHash().get(EnvironmentTools.CUSTOMER_CHANNEL, tenantid.toString());
			if(EnvironmentTools.DINGDING_CHANNEL.equals(customerChannel)) {
				return Utils.getDingDingDomain()+"/" + MetaData_GET_URL;
			}
		}
		return metaDataBaseUrl + MetaData_GET_URL;
	}

	public String getBaseHost() {
		Long tenantid = InvocationInfoProxy.getTenantid();
		if(tenantid != null && tenantid > 0l) {
			String customerChannel = (String) redisTemplate.opsForHash().get(EnvironmentTools.CUSTOMER_CHANNEL, tenantid.toString());
			if(EnvironmentTools.DINGDING_CHANNEL.equals(customerChannel)) {
				return Utils.getDingDingDomain()+"/";
			}
		}
		return metaDataBaseUrl;
	}

}
