package com.ejianc.framework.skeleton.refer.util;

import org.slf4j.LoggerFactory;

import com.ejianc.framework.core.exception.BusinessException;

/**
 * 异常处理工具 后面迁移到icop-exception
 *
 * @author guominga 2020-02-21
 */
public class ExceptionUtil {

	private final static org.slf4j.Logger Log = LoggerFactory.getLogger(ExceptionUtil.class);

	/**
	 * 在EJB边界对所有的异常进行BusinessException包装
	 * 
	 * @param ex
	 *            要处理的异常
	 * @throws BusinessException
	 *             要抛出EJB的异常
	 */
	public static void marsh(Exception ex) throws BusinessException {
		Throwable cause = ExceptionUtil.unmarsh(ex);
		Log.error(cause.getMessage(), cause);

		throw new BusinessException(ex.getMessage());

	}

	/**
	 * 将最底层的异常解析出来
	 * 
	 * @param ex
	 *            要处理的异养
	 * @return 最底层的异常
	 */
	public static Throwable unmarsh(Throwable ex) {
		Throwable cause = ex.getCause();
		if (cause != null) {
			cause = ExceptionUtil.unmarsh(cause);
		} else {
			cause = ex;
		}
		return cause;
	}

	/**
	 * 抛出业务异常
	 * 
	 * @param message
	 *            异常信息
	 */
	public static void wrappBusinessException(String message) {
		BusinessException ex = new BusinessException(message);
		Log.error(message, ex);

		throw new BusinessException(ex.getMessage());
	}

	/**
	 * 抛出业务异常
	 * 
	 * @param message
	 *            异常信息
	 * @param location
	 *            出现异常的位置
	 */
	public static void wrappBusinessException(String message, String location) {
		BusinessException ex = new BusinessException(message + location);
		Log.error(message + location, ex);

		throw new BusinessException(ex);
	}

	/**
	 * 将异常装载到快速异常通道中向上传递
	 * 
	 * @param ex
	 *            要装载的异常
	 */
	public static void wrappException(Exception ex) {
		Log.error(ex.getMessage(), ex);
		throw new BusinessException(ex);
	}

}
