/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.billState.controller;

import cn.hutool.json.JSONArray;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"common/testBpm"})
public class CommonTestBpmController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private IBillTypeApi billTypeApi;

    public static String toLowerCaseFirstOne(String param) {
        if (Character.isLowerCase(param.charAt(0))) {
            return param;
        }
        return Character.toLowerCase(param.charAt(0)) + param.substring(1);
    }

    private ICommonBusinessService obtainBusinessService(CommonBusinessParam businessParam) {
        if (businessParam.getBillTypeCode() == null) {
            throw new BusinessException("\u7f3a\u5c11\u5355\u636e\u7c7b\u578b\u7f16\u7801");
        }
        if (businessParam.getBillId() == null) {
            throw new BusinessException("\u7f3a\u5c11\u5355\u636e\u7c7b\u578b\u7f16\u7801");
        }
        Long metadataId = businessParam.getMetadataId();
        if (businessParam.getMetadataId() == null) {
            CommonResponse billTypeResponse = this.billTypeApi.getByCode(businessParam.getBillTypeCode());
            if (billTypeResponse.isSuccess()) {
                BillTypeVO billTypeVo = (BillTypeVO)billTypeResponse.getData();
                metadataId = billTypeVo.getMetadataId();
            } else {
                throw new BusinessException("\u672a\u6839\u636e\u5355\u636e\u7c7b\u578b\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5143\u6570\u636e");
            }
        }
        this.logger.info("\u8c03\u7528\u5143\u6570\u636eapi\u53c2\u6570\uff1a---------------" + metadataId);
        CommonResponse mdClassResponse = this.mdApi.queryMetadataById(metadataId);
        if (mdClassResponse.isSuccess()) {
            MdReferVO mdClassVo = (MdReferVO)mdClassResponse.getData();
            String serviceName = CommonTestBpmController.toLowerCaseFirstOne(mdClassVo.getEntityName().replace("Entity", ""));
            ICommonBusinessService businessService = null;
            try {
                businessService = ContextUtil.getBean(serviceName, ICommonBusinessService.class);
            }
            catch (Exception e) {
                businessService = ContextUtil.getBean("defaultBusinessService", ICommonBusinessService.class);
            }
            return businessService;
        }
        return null;
    }

    @RequestMapping(value={"beforeSubmit"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> beforeSubmitProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeSubmitProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"afterSubmit"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> afterSubmitProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.afterSubmitProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"beforeHasBpmBack"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> beforeHasBpmBack(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeHasBpmBack(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"afterHasBpmBack"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> afterHasBpmBack(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.afterHasBpmBack(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"beforeInApprovalBack"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> beforeInApprovalBack(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeInApprovalBack(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode(), businessParam.getSign());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"afterInApprovalBack"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> afterInApprovalBack(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.afterInApprovalBack(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode(), businessParam.getTaskId(), businessParam.getIsEnd(), businessParam.getSign(), businessParam.getOther());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"beforeApproval"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> beforeApprovalProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeApprovalProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"afterApproval"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> afterApprovalProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.afterApprovalProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"beforeAbstaining"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> beforeAbstainingProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeAbstainingProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"afterAbstaining"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> afterAbstainingProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.afterAbstainingProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"queryApproveUser"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONArray> queryApproveUser(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.queryApproveUser(businessParam.getBillId(), businessParam.getBillTypeCode(), businessParam.getSign(), businessParam.getOther());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }
}

