/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.billTenant.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billTenant.service.IBillTenantService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"common/billTenant"})
public class BillTenantController {
    @Autowired
    IBillTenantService iBillTenantService;

    @RequestMapping(value={"queryTenantTotalBill"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryTenantTotalBill(@RequestParam(value="tableName") String tableName) {
        List<JSONObject> res = this.iBillTenantService.queryTenantTotalBill(tableName);
        if (ListUtil.isNotEmpty(res)) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            String today = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)calendar.getTime());
            for (JSONObject re : res) {
                re.put("billCount", (Object)this.iBillTenantService.queryTenantTodayBill(tableName, today + " 00:00:00", today + " 23:59:59", re.getString("statisticTenantId")));
            }
        }
        return CommonResponse.success(res);
    }
}

