/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.refer.util;

import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtil {
    private static final Logger Log = LoggerFactory.getLogger(ExceptionUtil.class);

    public static void marsh(Exception ex) throws BusinessException {
        Throwable cause = ExceptionUtil.unmarsh(ex);
        Log.error(cause.getMessage(), cause);
        throw new BusinessException(ex.getMessage());
    }

    public static Throwable unmarsh(Throwable ex) {
        Throwable cause = ex.getCause();
        cause = cause != null ? ExceptionUtil.unmarsh(cause) : ex;
        return cause;
    }

    public static void wrappBusinessException(String message) {
        BusinessException ex = new BusinessException(message);
        Log.error(message, (Throwable)ex);
        throw new BusinessException(ex.getMessage());
    }

    public static void wrappBusinessException(String message, String location) {
        BusinessException ex = new BusinessException(message + location);
        Log.error(message + location, (Throwable)ex);
        throw new BusinessException((Throwable)ex);
    }

    public static void wrappException(Exception ex) {
        Log.error(ex.getMessage(), (Throwable)ex);
        throw new BusinessException((Throwable)ex);
    }
}

