package com.baomidou.mybatisplus.extension.service.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import cn.hutool.core.date.DateUtil;

/**
 * IService 实现类（ 泛型：M 是 mapper 对象，T 是实体 ， PK 是主键泛型 ）
 *
 * @author hubin
 * @since 2018-06-23
 */
@SuppressWarnings("unchecked")
public class ServiceImpl<M extends BaseMapper<T>, T> implements IService<T> {
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    protected M baseMapper;

    @Value("${extend.field.mode:false}")
    private Boolean extFieldsMode;
    @Autowired
    private ICustomBusinessDataService customBusinessDataService;

    @Override
    public M getBaseMapper() {
        return baseMapper;
    }

    /**
     * 判断数据库操作是否成功
     *
     * @param result 数据库操作返回影响条数
     * @return boolean
     */
    protected boolean retBool(Integer result) {
        return SqlHelper.retBool(result);
    }

    protected Class<T> currentModelClass() {
        return ReflectionKit.getSuperClassGenericType(getClass(), 1);
    }

    /**
     * 批量操作 SqlSession
     */
    protected SqlSession sqlSessionBatch() {
        return SqlHelper.sqlSessionBatch(currentModelClass());
    }

    /**
     * 释放sqlSession
     *
     * @param sqlSession session
     */
    protected void closeSqlSession(SqlSession sqlSession) {
        SqlSessionUtils.closeSqlSession(sqlSession, GlobalConfigUtils.currentSessionFactory(currentModelClass()));
    }

    /**
     * 获取 SqlStatement
     *
     * @param sqlMethod ignore
     * @return ignore
     */
    protected String sqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.table(currentModelClass()).getSqlStatement(sqlMethod.getMethod());
    }

    @Override
    public boolean save(T entity) {
        return retBool(baseMapper.insert(entity));
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        String sqlStatement = sqlStatement(SqlMethod.INSERT_ONE);
        try (SqlSession batchSqlSession = sqlSessionBatch()) {
            int i = 0;
            for (T anEntityList : entityList) {
                batchSqlSession.insert(sqlStatement, anEntityList);
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                i++;
            }
            batchSqlSession.flushStatements();
        }
        return true;
    }
    
    /**
     * 比较前端传过来的对象和数据库对象是否一致； 如果一直则不进行修改操作；
     * 
     * add by guoming 
     * 
     * @param source
     * @param target
     * @param tableInfo
     * @return
     */
    private Boolean compareBean(T source, T target, TableInfo tableInfo) {
    	boolean compareFlag  = true;
    	List<TableFieldInfo> fieldList = tableInfo.getFieldList();
    	Class<?> cls = currentModelClass();
    	if(fieldList != null && fieldList.size() > 0) {
    		for(TableFieldInfo tableFieldInfo:fieldList) {
    			Class<?> clazz = tableFieldInfo.getPropertyType();
    			String keyProperty = tableFieldInfo.getProperty();
    			Boolean isPublicProperty = false;
    			switch(keyProperty) {
    				case "createUserCode":
    					isPublicProperty = true;
    					break;
    				case "createTime":
    					isPublicProperty = true;
    					break;
    				case "updateUserCode":
    					isPublicProperty = true;
    					break;
    				case "updateTime":
    					isPublicProperty = true;
    					break;
    				case "dr":
    					isPublicProperty = true;
    					break;
    				case "syncEsFlag":
    					isPublicProperty = true;
    					break;
    				case "version":
    					isPublicProperty = true;
    					break;
    			}
    			if(isPublicProperty) {
    				continue;
    			}
    			
    			try {
    				if(String.class.isAssignableFrom(clazz)) {
        				String sourceVal = (String) ReflectionKit.getMethodValue(cls, source, keyProperty);
        				String targetVal = (String) ReflectionKit.getMethodValue(cls, target, keyProperty);
        				if(org.apache.commons.lang.StringUtils.isNotBlank(sourceVal) && sourceVal.equals(targetVal)) {
        					continue;
        				}else if(org.apache.commons.lang.StringUtils.isBlank(sourceVal) && org.apache.commons.lang.StringUtils.isBlank(targetVal)){
        					continue;
        				}else{
        					compareFlag = false;
        					break;
        				}
        			}else if(long.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
        				Long sourceVal = (Long) ReflectionKit.getMethodValue(cls, source, keyProperty);
        				Long targetVal = (Long) ReflectionKit.getMethodValue(cls, target, keyProperty);
        				if(sourceVal != null && sourceVal.equals(targetVal)) {
        					continue;
        				}else if(sourceVal == null && targetVal == null) {
        					continue;
        				}else{
        					compareFlag = false;
        					break;
        				}
        			}else if(int.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
        				Integer sourceVal = (Integer) ReflectionKit.getMethodValue(cls, source, keyProperty);
        				Integer targetVal = (Integer) ReflectionKit.getMethodValue(cls, target, keyProperty);
        				if(sourceVal != null && sourceVal.equals(targetVal)) {
        					continue;
        				}else if(sourceVal == null && targetVal == null){
        					continue;
        				}else{
        					compareFlag = false;
        					break;
        				}
        			}else if(boolean.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
        				Boolean sourceVal = (Boolean) ReflectionKit.getMethodValue(cls, source, keyProperty);
        				Boolean targetVal = (Boolean) ReflectionKit.getMethodValue(cls, target, keyProperty);
        				if(sourceVal != null && sourceVal.equals(targetVal)) {
        					continue;
        				}else{
        					compareFlag = false;
        					break;
        				}
        			}else if(BigDecimal.class.isAssignableFrom(clazz)) {
        				BigDecimal sourceVal = (BigDecimal) ReflectionKit.getMethodValue(cls, source, keyProperty);
        				BigDecimal targetVal = (BigDecimal) ReflectionKit.getMethodValue(cls, target, keyProperty);
        				
    					if(sourceVal == null && targetVal == null){
    						continue;
    					}else if(sourceVal != null && targetVal != null &&  sourceVal.compareTo(targetVal) == 0) {
    						continue;
    					}else {
    						compareFlag = false;
    						break;
    					}
        			}else if(java.util.Date.class.isAssignableFrom(clazz)) {
        				Date sourceVal = (Date) ReflectionKit.getMethodValue(cls, source, keyProperty);
        				Date targetVal = (Date) ReflectionKit.getMethodValue(cls, target, keyProperty);
        				if(sourceVal == null && targetVal == null){
        					continue;
        				} else if(sourceVal != null && targetVal != null && DateUtil.isSameTime(sourceVal, targetVal)) {
        					continue;
        				} else{
        					compareFlag = false;
        					break;
        				}
        			}else{
        				compareFlag = false;
    					break;
        			}
				} catch (Exception e) {
					compareFlag = false;
					break;
				}
    		}
    	}
    	return compareFlag;
    }
    
    /**
     * 随机生成三位数字字符串
     * 
     * @return
     */
    private static String produce() {
		String result = "";
		try {
			SecureRandom srandom = SecureRandom.getInstance("SHA1PRNG");
			result = srandom.nextInt(1000) + "";
		} catch (NoSuchAlgorithmException e) {}

		if (result.length() != 3) {
			return produce();
		}
		return result;
	}

    /**
     * TableId 注解存在更新记录，否插入一条记录
     *
     * @param entity 实体对象
     * @return boolean
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveOrUpdate(T entity) {
        boolean success = false;
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            Assert.notNull(tableInfo, "error: can not execute. because can not find cache of TableInfo for entity!");
            String keyProperty = tableInfo.getKeyProperty();
            Assert.notEmpty(keyProperty, "error: can not execute. because can not find column for id from entity!");
            String keyColumn = tableInfo.getKeyColumn();
            Assert.notEmpty(keyColumn, "error: can not execute. because can not find table key column for id from entity!");
            Object idVal = ReflectionKit.getMethodValue(cls, entity, tableInfo.getKeyProperty());
            
            T targetEntity = null;
            Map<String, Field> fieldMap = ReflectionKit.getFieldMap(cls);
            if(!StringUtils.checkValNull(idVal)) {
            	String rand = produce();
            	QueryWrapper<T> queryWrapper = new QueryWrapper<>();
            	queryWrapper.eq(keyColumn, idVal);
            	if(fieldMap.containsKey("dr")) {
                    queryWrapper.eq("dr", 0);
                }
            	queryWrapper.last(" and "+rand+"="+rand+" ");
            	targetEntity = baseMapper.selectOne(queryWrapper);
            }
            if(Objects.isNull(targetEntity)) {
                success = save(entity);
            }else{
            	if(!compareBean(entity, targetEntity, tableInfo)) {
                    success = updateById(entity);
            	}else{
                    success =  true;
            	}
            }
        }
        if(success){
            if(extFieldsMode) {
                /**主表扩展字段begin*/
                try {
                    Class<?> mainClass = entity.getClass();
                    Method customFieldMethod =  mainClass.getSuperclass().getDeclaredMethod("getCustomField",  null);
                    Map<String, Object> customFieldDataMap = (Map<String, Object>) customFieldMethod.invoke(entity, (Object[]) null);
                    if(customFieldDataMap != null && !customFieldDataMap.isEmpty()) {
                        CustomBusinessDataVO customBusinessDataVO = new CustomBusinessDataVO();
                        Method mainPkIdMethod =  mainClass.getSuperclass().getDeclaredMethod("getId",  null);
                        Long businessId = (Long) mainPkIdMethod.invoke(entity, (Object[]) null);
                        customBusinessDataVO.setBusinessId(businessId);
                        customBusinessDataVO.setBusinessData(JSON.toJSONString(customFieldDataMap));

                        List<CustomBusinessDataVO> customBusinessDataVos = new ArrayList<>();
                        customBusinessDataVos.add(customBusinessDataVO);
                        CommonResponse<String> mainResponse = customBusinessDataService.saveOrUpdateData(customBusinessDataVos);
                        if(!mainResponse.isSuccess()) {
                            throw new BusinessException("主表扩展字段插入失败！");
                        }
                    }
                } catch (Exception e) {
                    logger.warn("扩展数据存储或读取失败，如果有使用扩展字段，请在您的微服务数据库中建立ejc_custom_businessdata表");
                }
                /**主表扩展字段end*/
            }
        }
        return success;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        Assert.notEmpty(entityList, "error: entityList must not be empty");
        Class<?> cls = currentModelClass();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
        Assert.notNull(tableInfo, "error: can not execute. because can not find cache of TableInfo for entity!");
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty(keyProperty, "error: can not execute. because can not find column for id from entity!");
        String keyColumn = tableInfo.getKeyColumn();
        Assert.notEmpty(keyColumn, "error: can not execute. because can not find table key column for id from entity!");
        try (SqlSession batchSqlSession = sqlSessionBatch()) {
            int i = 0;
            Map<String, Field> fieldMap = ReflectionKit.getFieldMap(cls);
            for (T entity : entityList) {
                Object idVal = ReflectionKit.getMethodValue(cls, entity, keyProperty);

                T targetEntity = null;
                if(!StringUtils.checkValNull(idVal)) {
                	String rand = produce();
                	QueryWrapper<T> queryWrapper = new QueryWrapper<>();
                	queryWrapper.eq(keyColumn, idVal);
                	if(fieldMap.containsKey("dr")) {
                        queryWrapper.eq("dr", 0);
                    }
                	queryWrapper.last(" and "+rand+"="+rand+" ");
                	targetEntity = baseMapper.selectOne(queryWrapper);
                	
                }
                if (Objects.isNull(targetEntity)) {
                    batchSqlSession.insert(sqlStatement(SqlMethod.INSERT_ONE), entity);
                } else {
                	if(!compareBean(entity, targetEntity, tableInfo)) {
                		MapperMethod.ParamMap<T> param = new MapperMethod.ParamMap<>();
                        param.put(Constants.ENTITY, entity);
                        batchSqlSession.update(sqlStatement(SqlMethod.UPDATE_BY_ID), param);
                	}
                }
                // 不知道以后会不会有人说更新失败了还要执行插入 😂😂😂
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                i++;
            }
            batchSqlSession.flushStatements();
        }
        return true;
    }

    @Override
    public boolean removeById(Serializable id) {
        return SqlHelper.delBool(baseMapper.deleteById(id));
    }

    @Override
    public boolean removeByMap(Map<String, Object> columnMap) {
        Assert.notEmpty(columnMap, "error: columnMap must not be empty");
        return SqlHelper.delBool(baseMapper.deleteByMap(columnMap));
    }

    @Override
    public boolean remove(Wrapper<T> wrapper) {
        return SqlHelper.delBool(baseMapper.delete(wrapper));
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        return SqlHelper.delBool(baseMapper.deleteBatchIds(idList));
    }

    @Override
    public boolean updateById(T entity) {
        return retBool(baseMapper.updateById(entity));
    }

    @Override
    public boolean update(T entity, Wrapper<T> updateWrapper) {
        return retBool(baseMapper.update(entity, updateWrapper));
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        Assert.notEmpty(entityList, "error: entityList must not be empty");
        String sqlStatement = sqlStatement(SqlMethod.UPDATE_BY_ID);
        try (SqlSession batchSqlSession = sqlSessionBatch()) {
            int i = 0;
            for (T anEntityList : entityList) {
                MapperMethod.ParamMap<T> param = new MapperMethod.ParamMap<>();
                param.put(Constants.ENTITY, anEntityList);
                batchSqlSession.update(sqlStatement, param);
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                i++;
            }
            batchSqlSession.flushStatements();
        }
        return true;
    }

    @Override
    public T getById(Serializable id) {
    	T entity = baseMapper.selectById(id);
        return entity;
    }

    @Override
    public Collection<T> listByIds(Collection<? extends Serializable> idList) {
        return baseMapper.selectBatchIds(idList);
    }

    @Override
    public Collection<T> listByMap(Map<String, Object> columnMap) {
        return baseMapper.selectByMap(columnMap);
    }

    @Override
    public T getOne(Wrapper<T> queryWrapper, boolean throwEx) {
        if (throwEx) {
            return baseMapper.selectOne(queryWrapper);
        }
        return SqlHelper.getObject(baseMapper.selectList(queryWrapper));
    }

    @Override
    public Map<String, Object> getMap(Wrapper<T> queryWrapper) {
        return SqlHelper.getObject(baseMapper.selectMaps(queryWrapper));
    }

    @Override
    public int count(Wrapper<T> queryWrapper) {
        return SqlHelper.retCount(baseMapper.selectCount(queryWrapper));
    }

    @Override
    public List<T> list(Wrapper<T> queryWrapper) {
        return baseMapper.selectList(queryWrapper);
    }

    @Override
    public IPage<T> page(IPage<T> page, Wrapper<T> queryWrapper) {
        return baseMapper.selectPage(page, queryWrapper);
    }

    @Override
    public List<Map<String, Object>> listMaps(Wrapper<T> queryWrapper) {
        return baseMapper.selectMaps(queryWrapper);
    }

    @Override
    public <V> List<V> listObjs(Wrapper<T> queryWrapper, Function<? super Object, V> mapper) {
        return baseMapper.selectObjs(queryWrapper).stream().filter(Objects::nonNull).map(mapper).collect(Collectors.toList());
    }

    @Override
    public IPage<Map<String, Object>> pageMaps(IPage<T> page, Wrapper<T> queryWrapper) {
        return baseMapper.selectMapsPage(page, queryWrapper);
    }
 
}
