package com.ejianc.framework.skeleton.billState.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;

/**
 * 流程中心事件回调
 * 
 * @author guoming
 */
@Controller
@RequestMapping(value = "common/business")
public class CommonBusinessController {
	// 日志
	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private IMdApi mdApi;

	public static String toLowerCaseFirstOne(String param) {
		if (Character.isLowerCase(param.charAt(0))) {
			return param;
		} else {
			return (new StringBuilder()).append(Character.toLowerCase(param.charAt(0))).append(param.substring(1)).toString();
		}
	}
	
	private ICommonBusinessService obtainBusinessService(CommonBusinessParam businessParam) {
		logger.info("调用元数据api参数：---------------"+businessParam.getMetadataId());
		CommonResponse<MdReferVO> mdClassResponse = mdApi.queryMetadataById(businessParam.getMetadataId());
//		CommonResponse<MdClassVO> mdClassResponse = mdClassApi.queryDetail(businessParam.getMetadataId());
		if (mdClassResponse.isSuccess()) {
			MdReferVO mdClassVo = mdClassResponse.getData();
			String serviceName = toLowerCaseFirstOne(mdClassVo.getEntityName().replace("Entity", ""));
			ICommonBusinessService businessService = null;
			try{
				businessService = ContextUtil.getBean(serviceName, ICommonBusinessService.class);
			}catch (Exception e){
				businessService = ContextUtil.getBean("defaultBusinessService", ICommonBusinessService.class);
			}
			return businessService;
		}
		return null;
	}

	/**
	 * 加载流程变量
	 *
	 * @param billId
	 * @param billTypeCode
	 * @return
	 */
	@RequestMapping(value = "getBpmVariable", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> getBpmVariable(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.getBpmVariable(businessParam.getBillId(), businessParam.getBillTypeCode());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@RequestMapping(value = "beforeSubmit", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> beforeSubmitProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.beforeSubmitProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "afterSubmit", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> afterSubmitProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.afterSubmitProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@RequestMapping(value = "beforeHasBpmBack", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> beforeHasBpmBack(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.beforeHasBpmBack(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "afterHasBpmBack", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> afterHasBpmBack(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.afterHasBpmBack(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@RequestMapping(value = "beforeInApprovalBack", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> beforeInApprovalBack(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.beforeInApprovalBack(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode(), businessParam.getSign());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@RequestMapping(value = "afterInApprovalBack", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> afterInApprovalBack(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.afterInApprovalBack(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode(), businessParam.getTaskId(), businessParam.getIsEnd(), businessParam.getSign(), businessParam.getOther());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@RequestMapping(value = "beforeApproval", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> beforeApprovalProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.beforeApprovalProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "afterApproval", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> afterApprovalProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.afterApprovalProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@RequestMapping(value = "beforeAbstaining", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> beforeAbstainingProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.beforeAbstainingProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@RequestMapping(value = "afterAbstaining", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> afterAbstainingProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.afterAbstainingProcessor(businessParam.getBillId(), businessParam.getBillState(), businessParam.getBillTypeCode());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @return
	 */
	@RequestMapping(value = "queryApproveUser", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONArray> queryApproveUser(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.queryApproveUser(businessParam.getBillId(), businessParam.getBillTypeCode(), businessParam.getSign(), businessParam.getOther());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 审批--新的审批人员时回调
	 *
	 * @return
	 */
	@RequestMapping(value = "approveUserList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> approveUserList(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.approveUserList(businessParam.getBillId(), businessParam.getBillTypeCode(), businessParam.getSign(), businessParam.getTaskKey(), businessParam.getTaskName(), businessParam.getApproveUserList(), businessParam.getOther());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}
}
