/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.billState.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdRelationApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdQuoteVO;
import com.ejianc.foundation.metadata.vo.MdRelationQuoteVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.billState.mapper.CommonUpdateBillStateMapper;
import com.ejianc.framework.skeleton.billState.param.QueryBillDetailParam;
import com.ejianc.framework.skeleton.billState.param.QueryQuoteParam;
import com.ejianc.framework.skeleton.billState.param.UpdateBillStateParam;
import com.ejianc.framework.skeleton.billState.param.UpdateQuoteParam;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;
import com.ejianc.framework.skeleton.extdata.bean.CustomBusinessDataEntity;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class CommonUpdateBillStateServiceImpl
implements CommonUpdateBillStateService {
    private static final Logger Log = LoggerFactory.getLogger(CommonUpdateBillStateServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Value(value="${extend.field.mode:false}")
    private Boolean extFieldsMode;
    @Autowired
    private ICustomBusinessDataService customBusinessDataService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private CommonUpdateBillStateMapper mapper;
    @Autowired
    private IMdAttributeApi mdAttributeApi;
    @Autowired
    private IMdRelationApi mdRelationApi;
    @Autowired
    private IMdClassApi mdClassApi;
    @Autowired
    private IBillTypeApi billTypeApi;

    @Override
    public CommonResponse<String> updateBillState(UpdateBillStateParam updateBillStateParam) {
        Log.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u5f00\u59cb---------------------\u5c06\u5355\u636e\uff1a" + updateBillStateParam.getBillId() + "\u7684billState\u4fee\u6539\u4e3a" + updateBillStateParam.getBillState() + "");
        String billState = this.mapper.queryBillState(updateBillStateParam);
        this.mapper.updateBillState(updateBillStateParam);
        Log.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u6210\u529f---------------------\u5c06\u8868\uff1a" + updateBillStateParam.getTableName() + "\u4e2d\u7684\u5355\u636e\uff1a" + updateBillStateParam.getBillId() + "\u7684billState\u4fee\u6539\u4e3a" + updateBillStateParam.getBillState() + "");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)billState);
    }

    @Override
    public JSONObject queryBillDetail(QueryBillDetailParam queryBillDetailParam) {
        CommonResponse attributeResponse;
        if ("ejc_support_defdoc_detail".equals(queryBillDetailParam.getTableName())) {
            JSONObject jsonObject = this.mapper.queryDeodocDetail(queryBillDetailParam.getBillId());
            return jsonObject;
        }
        List<String> columnList = this.mapper.queryTableAttrList(queryBillDetailParam.getTableName());
        HashMap<String, String> columnMap = new HashMap<String, String>();
        if (columnList != null && columnList.size() > 0) {
            for (String column : columnList) {
                columnMap.put(column, column);
            }
        }
        if ((attributeResponse = this.mdAttributeApi.queryMainAttributeList(Long.valueOf(Long.parseLong(queryBillDetailParam.getMetadataId())))).isSuccess()) {
            List mdAttributeVos = (List)attributeResponse.getData();
            ArrayList<MdAttributeVO> customAttributeVos = new ArrayList<MdAttributeVO>();
            StringBuffer paramBuffer = new StringBuffer("");
            if (mdAttributeVos != null && mdAttributeVos.size() > 0) {
                for (MdAttributeVO mdAttributeVo : mdAttributeVos) {
                    if (columnMap.containsKey(mdAttributeVo.getColumnName())) {
                        paramBuffer.append("`" + mdAttributeVo.getColumnName() + "`").append(" as ").append("`" + mdAttributeVo.getAttributeName() + "`").append(",");
                    }
                    if (!"custom".equals(mdAttributeVo.getDescription())) continue;
                    customAttributeVos.add(mdAttributeVo);
                }
                if (StringUtils.isNotBlank((CharSequence)paramBuffer)) {
                    String parameter = paramBuffer.substring(0, paramBuffer.length() - 1);
                    JSONObject jsonObject = this.mapper.queryBillDetail(queryBillDetailParam.getTableName(), parameter, queryBillDetailParam.getBillId());
                    if (this.extFieldsMode.booleanValue()) {
                        QueryParam param = new QueryParam();
                        param.getParams().put("businessId", new Parameter("eq", (Object)queryBillDetailParam.getBillId()));
                        try {
                            List dataEntities = this.customBusinessDataService.queryList(param);
                            if (ListUtil.isNotEmpty(dataEntities)) {
                                CustomBusinessDataEntity dataEntity = (CustomBusinessDataEntity)dataEntities.get(0);
                                JSONObject map = JSONObject.parseObject((String)dataEntity.getBusinessData());
                                Log.info("\u5ba1\u6279\u67e5\u8be2\u5355\u636e" + queryBillDetailParam.getBillId() + "\u7684\u6269\u5c55\u6570\u636e\u4e3a\uff1a" + JSONObject.toJSONString((Object)map));
                                if (map != null) {
                                    for (MdAttributeVO attributeVO : customAttributeVos) {
                                        if (!Objects.nonNull(map.get((Object)attributeVO.getAttributeName()))) continue;
                                        switch (attributeVO.getCustomDataType()) {
                                            case "input": 
                                            case "date": 
                                            case "number": 
                                            case "currency": 
                                            case "textarea": {
                                                break;
                                            }
                                            case "select": 
                                            case "radiogroup": {
                                                map.put(attributeVO.getAttributeName(), (Object)JSONObject.parseObject((String)map.get((Object)attributeVO.getAttributeName()).toString()).getString("text"));
                                                break;
                                            }
                                            case "switch": {
                                                map.put(attributeVO.getAttributeName(), (Object)("true".equals(map.get((Object)attributeVO.getAttributeName())) ? "\u5f00" : "\u5173"));
                                                break;
                                            }
                                            case "enumselect": 
                                            case "inputrefer": {
                                                map.put(attributeVO.getAttributeName(), (Object)JSONObject.parseObject((String)map.get((Object)attributeVO.getAttributeName()).toString()).getString("name"));
                                            }
                                        }
                                    }
                                    jsonObject.putAll((Map)map);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.logger.warn("\u6269\u5c55\u6570\u636e\u5b58\u50a8\u6216\u8bfb\u53d6\u5931\u8d25\uff0c \u5982\u679c\u6709\u4f7f\u7528\u6269\u5c55\u5b57\u6bb5\uff0c\u8bf7\u5728\u60a8\u7684\u5fae\u670d\u52a1\u6570\u636e\u5e93\u4e2d\u5efa\u7acbejc_custom_businessdata\u8868");
                        }
                    }
                    Log.info("\u5ba1\u6279\u67e5\u8be2\u5355\u636e" + queryBillDetailParam.getBillId() + "\u7684\u6570\u636e\u4e3a\uff1a" + jsonObject.toJSONString());
                    return jsonObject;
                }
            }
        }
        return null;
    }

    @Override
    public String queryQuoteById(QueryQuoteParam queryQuoteParam) {
        String count = this.mapper.queryQuoteById(queryQuoteParam.getBillId(), queryQuoteParam.getTableName(), queryQuoteParam.getColumn(), InvocationInfoProxy.getTenantid(), queryQuoteParam.getBillIds());
        return count;
    }

    @Override
    public Map<String, String> queryQuoteBatch(QueryQuoteParam queryQuoteParam) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<String> checkBillId = queryQuoteParam.getBillIds();
        List<String> rs = this.mapper.queryQuoteBatch(checkBillId, queryQuoteParam.getTableName(), queryQuoteParam.getColumn(), InvocationInfoProxy.getTenantid());
        rs.stream().forEach(billId -> result.put((String)billId, "true"));
        checkBillId.removeAll(rs);
        if (CollectionUtils.isNotEmpty(checkBillId)) {
            checkBillId.stream().forEach(billId -> result.put((String)billId, "false"));
        }
        return result;
    }

    @Override
    public Long queryBillCount(QueryBillDetailParam queryBillDetailParam) {
        Long billCount = this.mapper.queryBillCount(queryBillDetailParam);
        return billCount;
    }

    @Override
    public void updateQuoteData(Long billId, String billTypeCode) {
        CommonResponse mdClassResponse;
        Long metadataId;
        CommonResponse mdRelationResponse;
        CommonResponse billTypeResponse = this.billTypeApi.getByCode(billTypeCode);
        if (billTypeResponse.isSuccess() && billTypeResponse.getData() != null && (mdRelationResponse = this.mdRelationApi.queryQuoteById(metadataId = ((BillTypeVO)billTypeResponse.getData()).getMetadataId())).isSuccess() && ((List)mdRelationResponse.getData()).size() > 0 && (mdClassResponse = this.mdClassApi.queryDetail(metadataId)).isSuccess() && mdClassResponse.getData() != null) {
            QueryBillDetailParam queryBillDetailParam = new QueryBillDetailParam();
            queryBillDetailParam.setBillId(billId.toString());
            queryBillDetailParam.setTableName(((MdClassVO)mdClassResponse.getData()).getTableName());
            queryBillDetailParam.setMetadataId(metadataId.toString());
            queryBillDetailParam.setTenantId(InvocationInfoProxy.getTenantid());
            JSONObject billData = this.queryBillDetail(queryBillDetailParam);
            Integer taskSize = ((List)mdRelationResponse.getData()).size() < 5 ? ((List)mdRelationResponse.getData()).size() : (((List)mdRelationResponse.getData()).size() > 10 ? 10 : 5);
            ExecutorService threadPool = Executors.newFixedThreadPool(taskSize);
            String authority = this.request.getHeader("authority");
            if (authority == null) {
                authority = (String)InvocationInfoProxy.getExtendAttribute((String)"authority");
            }
            RequestAttributes context = RequestContextHolder.getRequestAttributes();
            HashMap<String, Object> invocationInfo = new HashMap<String, Object>();
            invocationInfo.put("callid", InvocationInfoProxy.getCallid());
            invocationInfo.put("tenantid", InvocationInfoProxy.getTenantid());
            invocationInfo.put("employeeId", InvocationInfoProxy.getEmployeeId());
            invocationInfo.put("locale", InvocationInfoProxy.getLocale());
            invocationInfo.put("logints", InvocationInfoProxy.getLogints());
            invocationInfo.put("orgId", InvocationInfoProxy.getOrgId());
            invocationInfo.put("sysid", InvocationInfoProxy.getSysid());
            invocationInfo.put("theme", InvocationInfoProxy.getTheme());
            invocationInfo.put("timeZone", InvocationInfoProxy.getTimeZone());
            invocationInfo.put("usercode", InvocationInfoProxy.getUsercode());
            invocationInfo.put("userid", InvocationInfoProxy.getUserid());
            invocationInfo.put("userType", InvocationInfoProxy.getUserType());
            for (MdQuoteVO quoteVO : (List)mdRelationResponse.getData()) {
                if (quoteVO.getRelationQuoteList() == null || quoteVO.getRelationQuoteList().size() <= 0) continue;
                DoUpdateQuoteDataThread t1 = new DoUpdateQuoteDataThread(quoteVO, billData, authority, context, invocationInfo);
                threadPool.submit(t1);
            }
        }
    }

    @Override
    public void doUpdateQuoteData(UpdateQuoteParam updateQuoteParam) {
        String sql = "update " + updateQuoteParam.getTableName() + " set ";
        JSONObject data = updateQuoteParam.getData();
        for (Map.Entry entry : data.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            sql = sql + key + "='" + value + "',";
        }
        sql = sql.substring(0, sql.length() - 1);
        sql = sql + " where dr = 0 and " + updateQuoteParam.getColumn() + " = '" + updateQuoteParam.getColumnValue() + "'";
        this.mapper.updateQuoteData(sql);
    }

    public class DoUpdateQuoteDataThread
    extends Thread {
        private MdQuoteVO quoteVO;
        private RequestAttributes context;
        private String authority;
        private JSONObject billData;
        private Map<String, Object> invocationInfo;

        public DoUpdateQuoteDataThread(MdQuoteVO quoteVO, JSONObject billData, String authority, RequestAttributes context, Map<String, Object> invocationInfo) {
            this.quoteVO = quoteVO;
            this.billData = billData;
            this.context = context;
            this.authority = authority;
            this.invocationInfo = invocationInfo;
        }

        @Override
        public void run() {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            InvocationInfoProxy.setCallid(this.invocationInfo.get("callid") != null ? this.invocationInfo.get("callid").toString() : null);
            InvocationInfoProxy.setTenantid(this.invocationInfo.get("tenantid") != null ? Long.valueOf(Long.parseLong(this.invocationInfo.get("tenantid").toString())) : null);
            InvocationInfoProxy.setEmployeeId(this.invocationInfo.get("employeeId") != null ? Long.valueOf(Long.parseLong(this.invocationInfo.get("employeeId").toString())) : null);
            InvocationInfoProxy.setLocale(this.invocationInfo.get("locale") != null ? this.invocationInfo.get("locale").toString() : null);
            InvocationInfoProxy.setLogints(this.invocationInfo.get("logints") != null ? this.invocationInfo.get("logints").toString() : null);
            InvocationInfoProxy.setOrgId(this.invocationInfo.get("orgId") != null ? Long.valueOf(Long.parseLong(this.invocationInfo.get("orgId").toString())) : null);
            InvocationInfoProxy.setSysid(this.invocationInfo.get("sysid") != null ? this.invocationInfo.get("sysid").toString() : null);
            InvocationInfoProxy.setTheme(this.invocationInfo.get("theme") != null ? this.invocationInfo.get("theme").toString() : null);
            InvocationInfoProxy.setTimeZone(this.invocationInfo.get("timeZone") != null ? this.invocationInfo.get("timeZone").toString() : null);
            InvocationInfoProxy.setUsercode(this.invocationInfo.get("usercode") != null ? this.invocationInfo.get("usercode").toString() : null);
            InvocationInfoProxy.setUserid(this.invocationInfo.get("userid") != null ? Long.valueOf(Long.parseLong(this.invocationInfo.get("userid").toString())) : null);
            InvocationInfoProxy.setUserType(this.invocationInfo.get("userType") != null ? this.invocationInfo.get("userType").toString() : null);
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)this.authority);
            HashMap<String, Object> paramterMap = new HashMap<String, Object>();
            paramterMap.put("tableName", this.quoteVO.getTableName());
            paramterMap.put("column", this.quoteVO.getAttributeCode());
            paramterMap.put("columnValue", this.billData.get((Object)this.quoteVO.getSourceAttributeCode()));
            JSONObject data = new JSONObject();
            for (MdRelationQuoteVO relationQuoteVO : this.quoteVO.getRelationQuoteList()) {
                data.put(relationQuoteVO.getTargetField(), this.billData.get((Object)relationQuoteVO.getSourceFieldCode()));
            }
            paramterMap.put("data", data);
            if (data.size() > 0) {
                CommonUpdateBillStateServiceImpl.this.logger.info("\u4fee\u6539\u5f15\u7528\u4fe1\u606f\u53c2\u6570\uff1a---------------" + ((Object)paramterMap).toString());
                String paramterStr = CommonUpdateBillStateServiceImpl.this.gson.toJson(paramterMap);
                String url = CommonUpdateBillStateServiceImpl.this.environmentTools.getBaseHost() + this.quoteVO.getProjectName() + "/commonstate/doUpdateQuoteData";
                CommonUpdateBillStateServiceImpl.this.logger.info("\u4fee\u6539\u5f15\u7528\u4fe1\u606f\u4f20\u9012\u7684url\uff1a---------------" + url);
                try {
                    String result = ReferHttpClientUtils.postByJson(url, paramterStr);
                    CommonUpdateBillStateServiceImpl.this.logger.info("\u4fee\u6539\u5f15\u7528\u4fe1\u606f\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CommonUpdateBillStateServiceImpl.this.logger.info("\u4fee\u6539\u5f15\u7528\u4fe1\u606f\u5931\u8d25\uff1a---------------" + e.getMessage());
                }
            }
        }
    }
}

