package com.ejianc.framework.skeleton.extdata.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.support.idworker.api.IKeyGeneratorApi;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.extdata.bean.CustomBusinessDataEntity;
import com.ejianc.framework.skeleton.extdata.mapper.CustomBusinessDataMapper;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class CustomBusinessDataServiceImpl extends BaseServiceImpl<CustomBusinessDataMapper, CustomBusinessDataEntity> implements ICustomBusinessDataService {

	@Autowired
	private CustomBusinessDataMapper customBusinessDataMapper;

	@Autowired(required = false)
	private IKeyGeneratorApi keyGeneratorApi;

	@Override
	public CommonResponse<String> saveOrUpdateData(List<CustomBusinessDataVO> customBusinessDataVos) {
		//根据业务主键查询数据
		if(customBusinessDataVos != null && customBusinessDataVos.size() > 0) {
			for(CustomBusinessDataVO customBusinessDataVo:customBusinessDataVos) {
				if(StringUtils.isBlank(customBusinessDataVo.getBusinessData())) {
					customBusinessDataMapper.deleteByBusinessId(customBusinessDataVo.getBusinessId());
				}else{
					QueryWrapper<CustomBusinessDataEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("business_id", customBusinessDataVo.getBusinessId());
					CustomBusinessDataEntity saveData = super.getOne(queryWrapper);
					if(saveData != null) {
						saveData.setBusinessData(customBusinessDataVo.getBusinessData());
					}else{
						saveData = new CustomBusinessDataEntity();
						saveData.setId(keyGeneratorApi.generateKey());
						saveData.setBusinessId(customBusinessDataVo.getBusinessId());
						saveData.setBusinessData(customBusinessDataVo.getBusinessData());
					}
					super.saveOrUpdate(saveData, false);
				}
			}
		}
		return CommonResponse.success();
	}

	@Override
	public CommonResponse<Map<Long, CustomBusinessDataVO>> queryCustomBusinessData(List<Long> businessIdList) {
		if(businessIdList != null && businessIdList.size() > 0) {
			Map<Long, CustomBusinessDataVO> resultMap = new HashMap<Long, CustomBusinessDataVO>();
			for(Long businessId:businessIdList) {
				QueryWrapper<CustomBusinessDataEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("business_id", businessId);
				CustomBusinessDataEntity saveData = super.getOne(queryWrapper);
				if(saveData != null && StringUtils.isNotBlank(saveData.getBusinessData())) {
					CustomBusinessDataVO customBusinessDataVo = BeanMapper.map(saveData, CustomBusinessDataVO.class);
					resultMap.put(customBusinessDataVo.getBusinessId(), customBusinessDataVo);
				}
			}
			return CommonResponse.success(resultMap);
		}
		return CommonResponse.error("扩展数据为空");
	}

	@Override
	public CommonResponse<String> deleteCustomBusinessData(List<Long> businessIdList) {
		for(Long businessId:businessIdList) {
			customBusinessDataMapper.deleteByBusinessId(businessId);
		}
		return CommonResponse.success();
		
	}

}
