/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.refer.common.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.refer.common.mapper.CommonReferMapper;
import com.ejianc.framework.skeleton.refer.common.service.CommonReferService;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CommonReferServiceImpl
implements CommonReferService {
    private static final Logger Log = LoggerFactory.getLogger(CommonReferServiceImpl.class);
    @Autowired
    private CommonReferMapper commonReferMapper;
    @Value(value="${database.dbtype:mysql}")
    private String dbType;

    @Override
    public JSONArray getReferEntity(Map<String, Object> refMapList) {
        JSONArray json = new JSONArray();
        String valueId = refMapList.get("valueId").toString();
        StringBuffer parameters = new StringBuffer("");
        for (String key : refMapList.keySet()) {
            if (key.equals("valueId") || key.equals("databaseName") || key.equals("tableName")) continue;
            parameters.append(refMapList.get(key)).append(" as ").append(key).append(",");
        }
        if (StringUtils.isBlank((CharSequence)parameters)) {
            Log.error("---------------\u53c2\u7167\u8f6c\u6362\u5b57\u6bb5\u4e3a\u7a7a-----------");
            ExceptionUtil.wrappBusinessException("\u53c2\u7167\u8f6c\u6362\u5b57\u6bb5\u4e3a\u7a7a");
        } else {
            if (refMapList.get("databaseName") == null) {
                Log.error("---------------\u53c2\u7167\u8f6c\u6362\u65f6\u6570\u636e\u5e93\u5b57\u6bb5\u4e3a\u7a7a-----------");
                ExceptionUtil.wrappBusinessException("\u53c2\u7167\u8f6c\u6362\u65f6\u6570\u636e\u5e93\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (refMapList.get("tableName") == null) {
                Log.error("---------------\u53c2\u7167\u8f6c\u6362\u65f6\u8868\u540d\u5b57\u6bb5\u4e3a\u7a7a-----------");
                ExceptionUtil.wrappBusinessException("\u53c2\u7167\u8f6c\u6362\u65f6\u8868\u540d\u5b57\u6bb5\u4e3a\u7a7a");
            }
            String databaseName = refMapList.get("databaseName").toString();
            String tableName = refMapList.get("tableName").toString();
            String parameter = parameters.substring(0, parameters.length() - 1);
            if (tableName.indexOf("tenantId") != -1) {
                String tableNewName = tableName.replace("${tenantId}", InvocationInfoProxy.getTenantid().toString());
                List<String> tables = this.commonReferMapper.queryTables(databaseName, tableNewName, this.dbType);
                if (tables.size() > 0) {
                    json = this.commonReferMapper.getReferEntity(parameter, databaseName, tableNewName, valueId);
                } else {
                    tableNewName = tableName.replace("${tenantId}", "999999");
                    json = this.commonReferMapper.getReferEntity(parameter, databaseName, tableNewName, valueId);
                }
            } else {
                Long tenantId = InvocationInfoProxy.getTenantid();
                json = "ejc_support_defdoc_detail".equals(tableName) && tenantId != 999999L ? this.commonReferMapper.getReferDefdocEntity(parameter, valueId, tenantId) : this.commonReferMapper.getReferEntity(parameter, databaseName, tableName, valueId);
            }
        }
        return json;
    }

    @Override
    public JSONObject getAuditInfoEntity(Map<String, Object> refMapList) {
        JSONArray jsonArray;
        String userCode = (String)refMapList.get("userCode");
        if (StringUtils.isNotBlank((CharSequence)userCode) && (jsonArray = this.commonReferMapper.getAuditInfoEntity(userCode)).size() > 0) {
            return jsonArray.getJSONObject(0);
        }
        return null;
    }
}

