/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.filter;

import com.ejianc.framework.skeleton.filter.AccessControlFilter;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AccessControlConfiguration {
    @Value(value="${common.env.dev-debug.mode:false}")
    private String commonDevMode;
    @Value(value="${common.env.base-host:#{null}}")
    private String baseHost;

    @Bean(value={"accessControlFilter"})
    public FilterRegistrationBean<Filter> buildSingleSignOutFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(1);
        filterRegistrationBean.setFilter((Filter)new AccessControlFilter(this.commonDevMode, this.baseHost));
        filterRegistrationBean.setName("accessControlFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        System.out.println(this.commonDevMode);
        System.out.println(this.baseHost);
        return filterRegistrationBean;
    }
}

