/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.template.es;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.refer.common.mapper.CommonReferMapper;
import com.ejianc.framework.skeleton.template.es.EsEntity;
import com.ejianc.framework.skeleton.template.es.IBaseEsCudDao;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BaseEsCudDao
implements IBaseEsCudDao {
    @Autowired(required=false)
    private RestHighLevelClient client;
    @Autowired
    private CommonReferMapper commonReferMapper;

    @Override
    public void insertOrUpdateOne(String index, EsEntity entity) {
        String content = entity.getContent();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            JSONObject jsonObject = JSON.parseObject((String)content);
            IndexRequest request = new IndexRequest(index);
            request.id(jsonObject.getString("id"));
            request.source((Map)jsonObject, XContentType.JSON);
            try {
                this.client.index(request, RequestOptions.DEFAULT);
                this.commonReferMapper.updateDataStatus(index, jsonObject.getString("id"));
            }
            catch (IOException e) {
                try {
                    this.client.index(request, RequestOptions.DEFAULT);
                    this.commonReferMapper.updateDataStatus(index, jsonObject.getString("id"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    throw new BusinessException("\u7d22\u5f15\u65b0\u589e/\u4fee\u6539\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
                }
            }
        }
    }

    @Override
    public void insertOrUpdateBatch(String index, EsEntity entity) {
        String content = entity.getContent();
        BulkRequest request = new BulkRequest();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            JSONArray jsonArray = JSON.parseArray((String)content);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                request.add(new IndexRequest(index).id(jsonObject.getString("id")).source((Map)jsonObject, XContentType.JSON));
            }
            try {
                this.client.bulk(request, RequestOptions.DEFAULT);
                if (StringUtils.isNotBlank((CharSequence)content)) {
                    JSONArray dataArray = JSON.parseArray((String)content);
                    for (int i = 0; i < dataArray.size(); ++i) {
                        JSONObject dataObject = dataArray.getJSONObject(i);
                        this.commonReferMapper.updateDataStatus(index, dataObject.getString("id"));
                    }
                }
            }
            catch (IOException e) {
                try {
                    this.client.bulk(request, RequestOptions.DEFAULT);
                    if (StringUtils.isNotBlank((CharSequence)content)) {
                        JSONArray dataArray = JSON.parseArray((String)content);
                        for (int i = 0; i < dataArray.size(); ++i) {
                            JSONObject dataObject = dataArray.getJSONObject(i);
                            this.commonReferMapper.updateDataStatus(index, dataObject.getString("id"));
                        }
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    throw new BusinessException("\u6279\u91cf\u63d2\u5165\u6216\u4fee\u6539\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
                }
            }
        }
    }

    @Override
    public void deleteBatch(String index, EsEntity entity) {
        String content = entity.getContent();
        BulkRequest request = new BulkRequest();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            List ids = JSON.parseArray((String)content, String.class);
            for (String id : ids) {
                DeleteRequest deleteRequest = new DeleteRequest(index);
                deleteRequest.id(id);
                request.add(deleteRequest);
            }
        }
        try {
            this.client.bulk(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            try {
                this.client.bulk(request, RequestOptions.DEFAULT);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6279\u91cf\u5220\u9664\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
    }

    @Override
    public void deleteById(String index, EsEntity entity) {
        String content = entity.getContent();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            DeleteRequest request = new DeleteRequest(index);
            request.id(content);
            try {
                this.client.delete(request, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                try {
                    this.client.delete(request, RequestOptions.DEFAULT);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    throw new BusinessException("\u6839\u636e\u4e3b\u952eID\u5220\u9664\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
                }
            }
        }
    }
}

