package com.ejianc.framework.skeleton.billState.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdRelationApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdQuoteVO;
import com.ejianc.foundation.metadata.vo.MdRelationQuoteVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.billState.mapper.CommonUpdateBillStateMapper;
import com.ejianc.framework.skeleton.billState.param.QueryBillDetailParam;
import com.ejianc.framework.skeleton.billState.param.QueryQuoteParam;
import com.ejianc.framework.skeleton.billState.param.UpdateBillStateParam;
import com.ejianc.framework.skeleton.billState.param.UpdateQuoteParam;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;
import com.ejianc.framework.skeleton.extdata.bean.CustomBusinessDataEntity;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**  
  * Title: CommonUpdateBillStateServiceImpl  
  * Description: 
  * @author liyongjia  
  * @date 2020-05-14    
  */
@Service
public class CommonUpdateBillStateServiceImpl implements CommonUpdateBillStateService {
	private final static org.slf4j.Logger Log = LoggerFactory.getLogger(CommonUpdateBillStateServiceImpl.class);
	private final Logger logger = LoggerFactory.getLogger(getClass());
	private Gson gson = new Gson();
	@Value("${extend.field.mode:false}")
	private Boolean extFieldsMode;
	@Autowired
	private ICustomBusinessDataService customBusinessDataService;
	@Autowired
	private EnvironmentTools environmentTools;

	@Autowired
	private HttpServletRequest request;
	@Autowired
	private CommonUpdateBillStateMapper mapper;
	@Autowired
	private IMdAttributeApi mdAttributeApi;
	@Autowired
	private IMdRelationApi mdRelationApi;
	@Autowired
	private IMdClassApi mdClassApi;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Value("${database.dbtype:mysql}")
	private String dbType;

	@Override
	public CommonResponse<String> updateBillState(UpdateBillStateParam updateBillStateParam) {
		Log.info("修改单据状态开始---------------------将表：{}中的单据：{}的billState修改为{}", updateBillStateParam.getTableName(),updateBillStateParam.getBillId(),updateBillStateParam.getBillState());
		//先查询下单据之前的状态
		String billState = mapper.queryBillState(updateBillStateParam);
		//修改单据状态
		mapper.updateBillState(updateBillStateParam);
		logger.info("修改单据状态成功---------------------将表：{}中的单据：{}的billState修改为{}", updateBillStateParam.getTableName(),updateBillStateParam.getBillId(),updateBillStateParam.getBillState());
		return CommonResponse.success("查询成功", billState);
		
	}

	@Override
	public JSONObject queryBillDetail(QueryBillDetailParam queryBillDetailParam) {
		if("ejc_support_defdoc_detail".equals(queryBillDetailParam.getTableName())){
			Long tenantId = queryBillDetailParam.getTenantId();
			if(tenantId==null){
				tenantId = InvocationInfoProxy.getTenantid();
			}
			JSONObject jsonObject = mapper.queryDeodocDetail(queryBillDetailParam.getBillId(),tenantId);
			return jsonObject;
		}else{
			//查询元数据表结构
			List<String> columnList = mapper.queryTableAttrList(queryBillDetailParam.getTableName(),dbType);
			Map<String, String> columnMap = new HashMap<String, String>();
			if(columnList != null && columnList.size() > 0) {
				for(String column:columnList) {
					columnMap.put(column, column);
				}
			}
			CommonResponse<List<MdAttributeVO>> attributeResponse = mdAttributeApi.queryMainAttributeList(Long.parseLong(queryBillDetailParam.getMetadataId()));
			if(attributeResponse.isSuccess()) {
				List<MdAttributeVO> mdAttributeVos = attributeResponse.getData();
				List<MdAttributeVO> customAttributeVos = new ArrayList<>();
				StringBuffer paramBuffer = new StringBuffer("");
				if(mdAttributeVos != null && mdAttributeVos.size() > 0) {
					for(MdAttributeVO mdAttributeVo:mdAttributeVos) {
						if(columnMap.containsKey(mdAttributeVo.getColumnName())) {
							paramBuffer.append(("`"+mdAttributeVo.getColumnName()+"`")).append(" as ").append(("`"+mdAttributeVo.getAttributeName()+"`")).append(",");
						}
						if("custom".equals(mdAttributeVo.getDescription())){
							customAttributeVos.add(mdAttributeVo);
						}
					}
					if(StringUtils.isNotBlank(paramBuffer)) {
						String parameter = paramBuffer.substring(0, paramBuffer.length() - 1);
						JSONObject jsonObject = mapper.queryBillDetail(queryBillDetailParam.getTableName(), parameter, queryBillDetailParam.getBillId());
						if(extFieldsMode){
							QueryParam param = new QueryParam();
							param.getParams().put("businessId",new Parameter(QueryParam.EQ,queryBillDetailParam.getBillId()));
							try {
								List<CustomBusinessDataEntity> dataEntities = customBusinessDataService.queryList(param);
								if(ListUtil.isNotEmpty(dataEntities)){
									CustomBusinessDataEntity dataEntity = dataEntities.get(0);//取第一个
									JSONObject map = JSONObject.parseObject(dataEntity.getBusinessData());
									Log.info("审批查询单据"+queryBillDetailParam.getBillId()+"的扩展数据为："+JSONObject.toJSONString(map));
									if(map!=null){
										for (MdAttributeVO attributeVO : customAttributeVos) {
											if(Objects.nonNull(map.get(attributeVO.getAttributeName()))){
												switch (attributeVO.getCustomDataType()){
													case "input":
													case "date":
													case "number":
													case "currency":
													case "textarea":
														break;
													case "select":
													case "radiogroup":
														map.put(attributeVO.getAttributeName(),JSONObject.parseObject(map.get(attributeVO.getAttributeName()).toString()).getString("text"));
														break;
													case "switch":
														map.put(attributeVO.getAttributeName(),"true".equals(map.get(attributeVO.getAttributeName()))?"开":"关");
														break;
													case "enumselect":
													case "inputrefer":
														map.put(attributeVO.getAttributeName(),JSONObject.parseObject(map.get(attributeVO.getAttributeName()).toString()).getString("name"));
														break;
												}
											}
										}

										jsonObject.putAll(map);
									}
								}
							} catch (Exception e) {
								logger.warn("扩展数据存储或读取失败， 如果有使用扩展字段，请在您的微服务数据库中建立ejc_custom_businessdata表");
							}
						}
						Log.info("审批查询单据"+queryBillDetailParam.getBillId()+"的数据为："+jsonObject.toJSONString());
						return jsonObject;
					}
				}
			}
		}
		return null;
	}

	@Override
	public String queryQuoteById(QueryQuoteParam queryQuoteParam) {
		String count = mapper.queryQuoteById(queryQuoteParam.getBillId(),queryQuoteParam.getTableName(),
				queryQuoteParam.getColumn(), InvocationInfoProxy.getTenantid(), queryQuoteParam.getBillIds());
		return count;
	}

	@Override
	public Map<String, String> queryQuoteBatch(QueryQuoteParam queryQuoteParam) {
		Map<String, String> result = new HashMap<>();
		List<String> checkBillId = queryQuoteParam.getBillIds();
		List<String> rs = mapper.queryQuoteBatch(checkBillId, queryQuoteParam.getTableName(), queryQuoteParam.getColumn(), InvocationInfoProxy.getTenantid());

		rs.stream().forEach(billId -> result.put(billId, "true"));
		checkBillId.removeAll(rs);
		if(CollectionUtils.isNotEmpty(checkBillId)) {
			checkBillId.stream().forEach(billId -> result.put(billId, "false"));
		}

		return result;
	}

	@Override
	public Long queryBillCount(QueryBillDetailParam queryBillDetailParam) {
		Long billCount = mapper.queryBillCount(queryBillDetailParam);
		return billCount;
	}

	@Override
	public void updateQuoteData(Long billId, String billTypeCode) {
		CommonResponse<BillTypeVO> billTypeResponse = billTypeApi.getByCode(billTypeCode);
		if(billTypeResponse.isSuccess() && billTypeResponse.getData()!=null){
			Long metadataId = billTypeResponse.getData().getMetadataId();
			CommonResponse<List<MdQuoteVO>> mdRelationResponse = mdRelationApi.queryQuoteById(metadataId);
			if(mdRelationResponse.isSuccess() && mdRelationResponse.getData().size()>0){
				//获取当前数据库信息
				CommonResponse<MdClassVO> mdClassResponse = mdClassApi.queryDetail(metadataId);
				if(mdClassResponse.isSuccess() && mdClassResponse.getData()!=null){
					//获取单据信息
					QueryBillDetailParam queryBillDetailParam = new QueryBillDetailParam();
					queryBillDetailParam.setBillId(billId.toString());
					queryBillDetailParam.setTableName(mdClassResponse.getData().getTableName());
					queryBillDetailParam.setMetadataId(metadataId.toString());
					queryBillDetailParam.setTenantId(InvocationInfoProxy.getTenantid());
					JSONObject billData = this.queryBillDetail(queryBillDetailParam);

					//创建一个固定数量的线程池
					Integer taskSize = mdRelationResponse.getData().size()<5?mdRelationResponse.getData().size():(mdRelationResponse.getData().size()>10?10:5);
					ExecutorService threadPool = Executors.newFixedThreadPool(taskSize);

					String authority = request.getHeader("authority");
					if (authority == null) {
						authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
					}
					RequestAttributes context = RequestContextHolder.getRequestAttributes();
					Map<String, Object> invocationInfo = new HashMap<>();
					invocationInfo.put("callid", InvocationInfoProxy.getCallid());
					invocationInfo.put("tenantid", InvocationInfoProxy.getTenantid());
					invocationInfo.put("employeeId", InvocationInfoProxy.getEmployeeId());
					invocationInfo.put("locale", InvocationInfoProxy.getLocale());
					invocationInfo.put("logints", InvocationInfoProxy.getLogints());
					invocationInfo.put("orgId", InvocationInfoProxy.getOrgId());
					invocationInfo.put("sysid", InvocationInfoProxy.getSysid());
					invocationInfo.put("theme", InvocationInfoProxy.getTheme());
					invocationInfo.put("timeZone", InvocationInfoProxy.getTimeZone());
					invocationInfo.put("usercode", InvocationInfoProxy.getUsercode());
					invocationInfo.put("userid", InvocationInfoProxy.getUserid());
					invocationInfo.put("userType", InvocationInfoProxy.getUserType());

					for(MdQuoteVO quoteVO : mdRelationResponse.getData()){
						if(quoteVO.getRelationQuoteList()!=null && quoteVO.getRelationQuoteList().size()>0){
							DoUpdateQuoteDataThread t1 = new DoUpdateQuoteDataThread(quoteVO, billData, authority, context, invocationInfo);
							threadPool.submit(t1);
						}
					}
				}
			}
		}
	}


	public class DoUpdateQuoteDataThread extends Thread {
		private MdQuoteVO quoteVO;
		private RequestAttributes context;
		private String authority;
		private JSONObject billData;
		private Map<String,Object> invocationInfo;

		public DoUpdateQuoteDataThread(MdQuoteVO quoteVO,JSONObject billData,String authority,RequestAttributes context,Map<String,Object> invocationInfo) {
			this.quoteVO = quoteVO;
			this.billData = billData;
			this.context = context;
			this.authority = authority;
			this.invocationInfo = invocationInfo;
		}

		public void run() {
//			context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
			RequestContextHolder.setRequestAttributes(context);
			//初始化上下文
			InvocationInfoProxy.setCallid(invocationInfo.get("callid")!=null?invocationInfo.get("callid").toString():null);
			InvocationInfoProxy.setTenantid(invocationInfo.get("tenantid")!=null?Long.parseLong(invocationInfo.get("tenantid").toString()):null);
			InvocationInfoProxy.setEmployeeId(invocationInfo.get("employeeId")!=null?Long.parseLong(invocationInfo.get("employeeId").toString()):null);
			InvocationInfoProxy.setLocale(invocationInfo.get("locale")!=null?invocationInfo.get("locale").toString():null);
			InvocationInfoProxy.setLogints(invocationInfo.get("logints")!=null?invocationInfo.get("logints").toString():null);
			InvocationInfoProxy.setOrgId(invocationInfo.get("orgId")!=null?Long.parseLong(invocationInfo.get("orgId").toString()):null);
			InvocationInfoProxy.setSysid(invocationInfo.get("sysid")!=null?invocationInfo.get("sysid").toString():null);
			InvocationInfoProxy.setTheme(invocationInfo.get("theme")!=null?invocationInfo.get("theme").toString():null);
			InvocationInfoProxy.setTimeZone(invocationInfo.get("timeZone")!=null?invocationInfo.get("timeZone").toString():null);
			InvocationInfoProxy.setUsercode(invocationInfo.get("usercode")!=null?invocationInfo.get("usercode").toString():null);
			InvocationInfoProxy.setUserid(invocationInfo.get("userid")!=null?Long.parseLong(invocationInfo.get("userid").toString()):null);
			InvocationInfoProxy.setUserType(invocationInfo.get("userType")!=null?invocationInfo.get("userType").toString():null);

			InvocationInfoProxy.setExtendAttribute("authority", authority);

			Map<String, Object> paramterMap = new HashMap<>();
			paramterMap.put("tableName", quoteVO.getTableName());
			paramterMap.put("column", quoteVO.getAttributeCode());
			paramterMap.put("columnValue", billData.get(quoteVO.getSourceAttributeCode()));
			JSONObject data = new JSONObject();
			for(MdRelationQuoteVO relationQuoteVO : quoteVO.getRelationQuoteList()){
				data.put(relationQuoteVO.getTargetField(), billData.get(relationQuoteVO.getSourceFieldCode()));
			}
			paramterMap.put("data", data);
			if(data.size()>0){
				logger.info("修改引用信息参数：---------------"+ paramterMap.toString());
				String paramterStr = gson.toJson(paramterMap);
				String url = environmentTools.getBaseHost() + quoteVO.getProjectName() + "/commonstate/doUpdateQuoteData";
				logger.info("修改引用信息传递的url：---------------"+url);
				try {
					String result = ReferHttpClientUtils.postByJson(url, paramterStr);
					logger.info("修改引用信息返回的结果：---------------"+result);
				} catch (Exception e) {
					e.printStackTrace();
					logger.info("修改引用信息失败：---------------"+e.getMessage());
				}
			}
		}

	}
	@Override
	public void doUpdateQuoteData(UpdateQuoteParam updateQuoteParam) {
		String sql = "update " + updateQuoteParam.getTableName() + " set ";
		JSONObject data = updateQuoteParam.getData();
		Iterator iter = data.entrySet().iterator();
		while (iter.hasNext()) {
			Map.Entry entry = (Map.Entry) iter.next();
			String key = entry.getKey().toString();
			String value = entry.getValue().toString();
			sql += (key+"='"+value+"',");
		}
		sql = sql.substring(0, sql.length()-1);
		sql += (" where dr = 0 and " + updateQuoteParam.getColumn() + " = '" + updateQuoteParam.getColumnValue() + "'");
		mapper.updateQuoteData(sql);
	}
}
