package com.ejianc.framework.skeleton.billTenant.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billTenant.service.IBillTenantService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Calendar;
import java.util.List;

/**
 * 租户单据制单量统计
 *
 * @author mrsir
 */
@Controller
@RequestMapping(value = "common/billTenant")
public class BillTenantController {

    @Autowired
    IBillTenantService iBillTenantService;

    /**
     * 根据租户分组查询每个租户制单数量
     *
     * @param tableName  数据库表名
     * @return
     */
    @RequestMapping(value = "queryTenantTotalBill", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryTenantTotalBill(@RequestParam("tableName") String tableName) {
        List<JSONObject> res = iBillTenantService.queryTenantTotalBill(tableName);
        if(ListUtil.isNotEmpty(res)){
            Calendar calendar = Calendar.getInstance();
            // 将日期减一天
            calendar.add(Calendar.DATE, -1);
            String today = DateFormatUtil.formatDate("yyyy-MM-dd",calendar.getTime());
            for (JSONObject re : res) {
                re.put("billCount",iBillTenantService.queryTenantTodayBill(tableName,today+" 00:00:00",today+" 23:59:59",re.getString("statisticTenantId")));
            }
        }
        return CommonResponse.success(res);
    }
}
