package com.ejianc.framework.skeleton.dataPush.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.dataPush.IGuoWanDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.util.EjcCloudApiHttpTools;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;


@Service
public class GuoWanDataPushServiceImpl implements IGuoWanDataPushService {
	@Autowired
	private EjcCloudApiHttpTools ejcCloudApiHttpTools;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	@Autowired
	private EnvironmentTools environmentTools;
	@Value("${ejc.cloud.api.host}")
	/**
	 *
	 * 数据流向  供应商====调用=>>>>招标方
	 *
	 * @param targetTenantId        第三方系统id，来源公有云企业档案id或者数据中的systemId 必填
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx?xxx=xxx&xxx=xxx,注意get方式参数拼接在这个参数后面，以/开头  注意，工程路径后面需要加上openapi，否则无法调通，必填
	 * @param method          RequestMethod.POST  或者 RequestMethod.GET  必填
	 * @param postData        post方式请求的数据  post方式必填
	 * @return
	 */
	@Override
	public CommonResponse<String> exchangeDataWithOtherTenant(String url,RequestMethod method,String params,String targetTenantId) {
		if(StringUtils.isEmpty(targetTenantId)){
			return CommonResponse.error("targetTenantId不能为空！");
		}
		CommonResponse<JSONObject> response = getAuthInfoByTenantId(targetTenantId);
		if(!response.isSuccess()){
			return CommonResponse.error(response.getMsg());
		}
		JSONObject auth = response.getData();
		if(RequestMethod.POST.name().equals(method.name())){
			if(StringUtils.isEmpty(params)){
				return CommonResponse.error("POST方式 ， params不能为空！");
			}
			return  ejcCloudApiHttpTools.postByJson(null,auth.getString("appId"),auth.getString("appSecret"),auth.getString("appHost"),url,params);
		}
		return ejcCloudApiHttpTools.getByJson(null,auth.getString("appId"),auth.getString("appSecret"),auth.getString("appHost"),url,StringUtils.isEmpty(params)?null:JSONObject.parseObject(params));
	}

	/**
	 * 数据流向  供应商====调用=>>>>招标方 包含文件传输 POST方式
	 *
	 * @param url      接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,以/开头 注意，工程路径后面需要加上openapi，否则无法调通， 必填
	 * @param params   参数
	 * @param targetTenantId 第三方系统id，来源公有云企业档案id或者数据中的systemId 必填
	 * @param files    文件列表
	 * @return
	 */
	@Override
	public CommonResponse<String> exchangeDataAndFilesWithOtherTenant(String url, Map<String, String> params, String targetTenantId, Map<String, Map<String, InputStream>> files) {
		CommonResponse<JSONObject> response = getAuthInfoByTenantId(targetTenantId);
		if(!response.isSuccess()){
			return CommonResponse.error(response.getMsg());
		}
		JSONObject auth = response.getData();
		return ejcCloudApiHttpTools.postWithFile(null,auth.getString("appId"),auth.getString("appSecret"),auth.getString("appHost"),url,params,files);
	}

	/**
	 * 向任意租户推送数据
	 *
	 * @param url        接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,以/开头 必填
	 * @param method     RequestMethod.POST  或者 RequestMethod.GET  必填
	 * @param params     请求的数据 post方式必填
	 * @param supplierId 目标租户id 必填
	 * @return
	 */
	@Override
	public CommonResponse<String> exchangeDataWithSupplier(String url, RequestMethod method, String params, String supplierId) {
        try {
			JSONObject p = new JSONObject();
			p.put("id",supplierId);
			String result = ReferHttpClientUtils.get(environmentTools.getBaseHost()+"ejc-support-web/tenantSupplier/queryDetail",p,ReferHttpClientUtils.getHeaders());
			if(StringUtils.isNotEmpty(result)){
				JSONObject res = JSONObject.parseObject(result);
				if(res.getInteger("code") == 0){
					JSONObject data = res.getJSONObject("data");
					String tenant = data.getString("tenant");
					if(!Objects.equals(data.getLong("tenantId"), InvocationInfoProxy.getTenantid())){
						return CommonResponse.error("当前租户与目标供应商引入信息不匹配，无法推送数据！");
					}
					if(StringUtils.isNotEmpty(tenant)){
						return exchangeDataWithOtherTenant(url,method,params,tenant);
					}else {
						return CommonResponse.error("查询该供应商未协同，无法推送数据！");
					}
				}else {
					return CommonResponse.error("查询供应商信息失败！");
				}
			}else {
				return CommonResponse.error("查询供应商信息失败！");
			}
        } catch (Exception e) {
			e.printStackTrace();
			return CommonResponse.error("查询供应商信息发生异常！=>"+e.getMessage());
        }
	}

	/**
	 * 向任意租户推送数据 携带文件
	 *
	 * @param url        接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,以/开头 必填
	 * @param params     参数
	 * @param supplierId 目标租户id 必填
	 * @param files      文件列表
	 * @return
	 */
	@Override
	public CommonResponse<String> exchangeDataAndFilesWithSupplier(String url, Map<String, String> params, String supplierId, Map<String, Map<String, InputStream>> files) {
		try {
			JSONObject p = new JSONObject();
			p.put("id",supplierId);
			String result = ReferHttpClientUtils.get(environmentTools.getBaseHost()+"ejc-support-web/tenantSupplier/queryDetail",p,ReferHttpClientUtils.getHeaders());
			if(StringUtils.isNotEmpty(result)){
				JSONObject res = JSONObject.parseObject(result);
				if(res.getInteger("code") == 0){
					JSONObject data = res.getJSONObject("data");
					if(!Objects.equals(data.getLong("tenantId"), InvocationInfoProxy.getTenantid())){
						return CommonResponse.error("当前租户与目标供应商引入信息不匹配，无法推送数据！");
					}
					String tenant = data.getString("tenant");
					if(StringUtils.isNotEmpty(tenant)){
						return exchangeDataAndFilesWithOtherTenant(url,params,tenant,files);
					}else {
						return CommonResponse.error("查询该供应商未协同，无法推送数据！");
					}
				}else {
					return CommonResponse.error("查询供应商信息失败！");
				}
			}else {
				return CommonResponse.error("查询供应商信息失败！");
			}
		} catch (Exception e) {
			e.printStackTrace();
			return CommonResponse.error("查询供应商信息发生异常！=>"+e.getMessage());
		}
	}

	public CommonResponse<JSONObject> getAuthInfoByTenantId(String tenantId){
		JSONObject auth = new JSONObject();
		try {
			if(redisTemplate.opsForValue().get("Enterprise-Open-Api-Info-"+tenantId) == null){
				Map<String, String> params = new HashMap<>();
				params.put("tenantId",tenantId);
				String result = ReferHttpClientUtils.get(environmentTools.getBaseHost()+"ejc-idm-web/enterprise/queryEnByTetId",params,ReferHttpClientUtils.getHeaders());
				if(StringUtils.isNotEmpty(result)){
					JSONObject res = JSONObject.parseObject(result);
					if(res.getInteger("code") == 0){
						JSONObject data = res.getJSONObject("data");
						String appId = data.getString("dataAppId");
						String secret = data.getString("dataAppSecret");
						if( StringUtils.isEmpty(appId) || StringUtils.isEmpty(secret)){
							return CommonResponse.error("查询企业配置信息dataAppId或者dataAppSecret为空！");
						}
						redisTemplate.opsForValue().set("Enterprise-Open-Api-Info-"+tenantId, appId+"------"+secret, 2, TimeUnit.DAYS);
					}else {
						return CommonResponse.error("查询企业配置信息失败！");
					}
				}else {
					return CommonResponse.error("查询企业配置信息失败！");
				}
			}
		}catch (Exception e){
			return CommonResponse.error("查询企业配置信息失败！");
		}
		String cacheData = Objects.requireNonNull(redisTemplate.opsForValue().get("Enterprise-Open-Api-Info-" + tenantId)).toString();
		String appHost = environmentTools.getBaseHost();
		String appId = cacheData.split("------")[0];
		String appSecret = cacheData.split("------")[1];
		auth.put("appHost",appHost);
		auth.put("appId",appId);
		auth.put("appSecret",appSecret);
		return CommonResponse.success(auth);
	}
}
