package com.ejianc.framework.skeleton.extdata.service;

import java.util.List;
import java.util.Map;

import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.extdata.bean.CustomBusinessDataEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface ICustomBusinessDataService extends IBaseService<CustomBusinessDataEntity> {

	/**
	 * 保存业务扩展数据
	 * 
	 * @param customBusinessDataVos
	 * @return
	 */
	CommonResponse<String> saveOrUpdateData(List<CustomBusinessDataVO> customBusinessDataVos);

	/**
	 * 查询所有的业务扩展数据
	 * 
	 * @param businessIdList
	 * @return
	 */
	CommonResponse<Map<Long, CustomBusinessDataVO>> queryCustomBusinessData(List<Long> businessIdList);

	/**
	 * 删除扩展数据
	 * 
	 * @param mainBusinessIdList
	 * @return
	 */
	CommonResponse<String> deleteCustomBusinessData(List<Long> mainBusinessIdList);


	List<Long> searchCustomBusinessData(String searchText);

}
