package com.ejianc.framework.skeleton.fieldCompare;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * @description: 实体对比注解
 * beforeKeyPrefix 旧字段（变更前字段）前缀，依据此字段来设置变更前字段的值
 * compareKey 依据哪个值做关联对比，子表集合对比时必须要有
 * changeFlag 数据变化标识字段，设置后，在此字段设置当前数据变更类型，add或update
 * differnceList 变化明细项：字段、旧值、新值
 *
 * @author songlx
 * @date: 2024/4/26
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface DifferenceComparison {

    String beforeKeyPrefix() default "";

    String compareKey() default "id";

    String changeFlag() default "";

    String differnceList() default "";

    String parentKey() default "parentId";

}