package com.ejianc.framework.skeleton.report.controller;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.report.param.CommonReportParam;
import com.ejianc.framework.skeleton.report.service.ICommonReportService;
import com.ejianc.framework.skeleton.util.JdkBase64Util;

/**
 * 报表公共服务
 * 
 * @author guoming
 */
@Controller
@RequestMapping(value = "common/report")
public class CommonReportController implements Serializable {

	private static final long serialVersionUID = 8227497523478327706L;
	
	@Autowired
	private ICommonReportService commonReportService;
	
	@RequestMapping(value = "parse", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<JSONObject>> parse(@RequestBody CommonReportParam reportParam) {
		String sqlContent = reportParam.getSqlContent();
		sqlContent = JdkBase64Util.decode(sqlContent);
		if(StringUtils.isNotBlank(sqlContent)) {
			if(sqlContent.toLowerCase().indexOf(";") != -1 || sqlContent.toLowerCase().indexOf("drop") != -1 
					|| sqlContent.toLowerCase().indexOf("insert") != -1 || sqlContent.toLowerCase().indexOf("update") != -1 
					|| sqlContent.toLowerCase().indexOf("delete") != -1) {
				throw new BusinessException("执行sql中不允许含有drop、insert、update、delete关键字。");
			}
		}
		List<JSONObject> resultList = commonReportService.queryReportList(sqlContent, reportParam.getDatasetType(), reportParam.getParams());
		return CommonResponse.success(resultList);
	}
}
