package com.ejianc.framework.skeleton.util;

import com.ejianc.framework.skeleton.template.BaseTreeVO;
import org.apache.commons.lang3.StringUtils;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;

public class ComparatorTree implements Comparator<BaseTreeVO> {
    public ComparatorTree() {
    }

    public int compare(BaseTreeVO vo1, BaseTreeVO vo2) {
        if(StringUtils.isBlank(vo1.getInnerCode()) || StringUtils.isBlank(vo2.getInnerCode())) {
            return createTimeCompare(vo1, vo2);
        } else {
            return innerCodeCompare(vo1, vo2);
        }
    }

    private int innerCodeCompare(BaseTreeVO vo1, BaseTreeVO vo2) {
        BigInteger j1 = new BigInteger(vo1.getInnerCode());
        BigInteger j2 = new BigInteger(vo2.getInnerCode());
        return j1.compareTo(j2) == -1 ? -1 : (j1.equals(j2) ? 0 : 1);
    }

    private int createTimeCompare(BaseTreeVO vo1, BaseTreeVO vo2) {
        Date d1 = vo1.getCreateTime();
        Date d2 = vo2.getCreateTime();
        return d1.compareTo(d2);
    }
}
