/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton;

import com.ejianc.framework.skeleton.ShardingMasterSlaveConfig;
import com.ejianc.framework.skeleton.TxAttrConfig;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.util.SeataUtils;
import com.google.common.collect.Maps;
import io.shardingjdbc.core.api.MasterSlaveDataSourceFactory;
import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
@EnableConfigurationProperties(value={ShardingMasterSlaveConfig.class, TxAttrConfig.class})
public class ShardingDataSourceConfig {
    @Value(value="${eureka.client.serviceUrl.defaultZone:#{null}}")
    private String serviceUrl;
    @Autowired(required=false)
    private ShardingMasterSlaveConfig shardingMasterSlaveConfig;
    @Autowired(required=false)
    private TxAttrConfig txAttrConfig;
    @Value(value="${database.dbtype:mysql}")
    private String dbType;

    @Bean(value={"contextUtil"})
    public ContextUtil contextUtil() {
        return new ContextUtil();
    }

    @Bean(value={"dataSource"})
    public DataSource masterSlaveDataSource() {
        System.out.println("******************\u4f7f\u7528" + this.dbType + "\u6570\u636e\u5e93******************");
        DataSource dataSource = null;
        if (this.shardingMasterSlaveConfig != null) {
            HashMap dataSourceMap = Maps.newHashMap();
            dataSourceMap.putAll(this.shardingMasterSlaveConfig.getDataSources());
            try {
                SeataUtils.getInstance().setServiceUrl(this.serviceUrl);
                SeataUtils.getInstance().setDataSource((DataSource)this.shardingMasterSlaveConfig.getDataSources().get("ds_master"));
                dataSource = Objects.equals("dmdb", this.dbType) ? (DataSource)this.shardingMasterSlaveConfig.getDataSources().get("ds_master") : MasterSlaveDataSourceFactory.createDataSource((Map)dataSourceMap, (MasterSlaveRuleConfiguration)this.shardingMasterSlaveConfig.getMasterSlaveRule(), (Map)Maps.newHashMap());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return dataSource;
    }

    @Bean
    public DataSourceTransactionManager getTransactionManager() {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager();
        transactionManager.setDataSource(this.masterSlaveDataSource());
        return transactionManager;
    }

    @Bean
    public TransactionInterceptor getTxAdvice() {
        DefaultTransactionAttribute txAttrRequire = new DefaultTransactionAttribute();
        txAttrRequire.setPropagationBehavior(0);
        DefaultTransactionAttribute txAttrRequireReadonly = new DefaultTransactionAttribute();
        txAttrRequireReadonly.setPropagationBehavior(0);
        txAttrRequireReadonly.setReadOnly(true);
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        if (this.txAttrConfig != null) {
            String[] txAttrRead;
            Map<String, String[]> txAttrMap = this.txAttrConfig.getTxAttrs();
            String[] txAttrRw = txAttrMap.get("txAttrRw");
            if (txAttrRw != null && txAttrRw.length > 0) {
                for (String rw : txAttrRw) {
                    source.addTransactionalMethod(rw, (TransactionAttribute)txAttrRequire);
                }
            }
            if ((txAttrRead = txAttrMap.get("trAttrRead")) != null && txAttrRead.length > 0) {
                for (String read : txAttrRead) {
                    source.addTransactionalMethod(read, (TransactionAttribute)txAttrRequireReadonly);
                }
            }
        }
        source.addTransactionalMethod("*", (TransactionAttribute)txAttrRequire);
        return new TransactionInterceptor((PlatformTransactionManager)this.getTransactionManager(), (TransactionAttributeSource)source);
    }

    @Bean
    public DefaultPointcutAdvisor defaultPointcutAdvisor() {
        DefaultPointcutAdvisor pointcutAdvisor = new DefaultPointcutAdvisor();
        pointcutAdvisor.setAdvice((Advice)this.getTxAdvice());
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution (* *..*Service.*(..))");
        pointcutAdvisor.setPointcut((Pointcut)pointcut);
        return pointcutAdvisor;
    }
}

