/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.dataPush.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.dataPush.IGuoWanDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.util.EjcCloudApiHttpTools;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class GuoWanDataPushServiceImpl
implements IGuoWanDataPushService {
    @Autowired
    private EjcCloudApiHttpTools ejcCloudApiHttpTools;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    @Value(value="${ejc.cloud.api.host}")
    public CommonResponse<String> exchangeDataWithOtherTenant(String url, RequestMethod method, String params, String targetTenantId) {
        if (StringUtils.isEmpty((CharSequence)targetTenantId)) {
            return CommonResponse.error((String)"targetTenantId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CommonResponse<JSONObject> response = this.getAuthInfoByTenantId(targetTenantId);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        JSONObject auth = (JSONObject)response.getData();
        if (RequestMethod.POST.name().equals(method.name())) {
            if (StringUtils.isEmpty((CharSequence)params)) {
                return CommonResponse.error((String)"POST\u65b9\u5f0f \uff0c params\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            return this.ejcCloudApiHttpTools.postByJson(null, auth.getString("appId"), auth.getString("appSecret"), auth.getString("appHost"), url, params);
        }
        return this.ejcCloudApiHttpTools.getByJson(null, auth.getString("appId"), auth.getString("appSecret"), auth.getString("appHost"), url, (Map<String, ?>)(StringUtils.isEmpty((CharSequence)params) ? null : JSONObject.parseObject((String)params)));
    }

    @Override
    public CommonResponse<String> exchangeDataAndFilesWithOtherTenant(String url, Map<String, String> params, String targetTenantId, Map<String, Map<String, InputStream>> files) {
        CommonResponse<JSONObject> response = this.getAuthInfoByTenantId(targetTenantId);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        JSONObject auth = (JSONObject)response.getData();
        return this.ejcCloudApiHttpTools.postWithFile(null, auth.getString("appId"), auth.getString("appSecret"), auth.getString("appHost"), url, params, files);
    }

    @Override
    public CommonResponse<String> exchangeDataWithSupplier(String url, RequestMethod method, String params, String supplierId) {
        try {
            JSONObject p = new JSONObject();
            p.put("id", (Object)supplierId);
            String result = ReferHttpClientUtils.get(this.environmentTools.getBaseHost() + "ejc-support-web/tenantSupplier/queryDetail", p, ReferHttpClientUtils.getHeaders());
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                JSONObject res = JSONObject.parseObject((String)result);
                if (res.getInteger("code") == 0) {
                    JSONObject data = res.getJSONObject("data");
                    String tenant = data.getString("tenant");
                    if (!Objects.equals(data.getLong("tenantId"), InvocationInfoProxy.getTenantid())) {
                        return CommonResponse.error((String)"\u5f53\u524d\u79df\u6237\u4e0e\u76ee\u6807\u4f9b\u5e94\u5546\u5f15\u5165\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u63a8\u9001\u6570\u636e\uff01");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)tenant)) {
                        return this.exchangeDataWithOtherTenant(url, method, params, tenant);
                    }
                    return CommonResponse.error((String)"\u67e5\u8be2\u8be5\u4f9b\u5e94\u5546\u672a\u534f\u540c\uff0c\u65e0\u6cd5\u63a8\u9001\u6570\u636e\uff01");
                }
                return CommonResponse.error((String)"\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            return CommonResponse.error((String)"\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff01=>" + e.getMessage()));
        }
    }

    @Override
    public CommonResponse<String> exchangeDataAndFilesWithSupplier(String url, Map<String, String> params, String supplierId, Map<String, Map<String, InputStream>> files) {
        try {
            JSONObject p = new JSONObject();
            p.put("id", (Object)supplierId);
            String result = ReferHttpClientUtils.get(this.environmentTools.getBaseHost() + "ejc-support-web/tenantSupplier/queryDetail", p, ReferHttpClientUtils.getHeaders());
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                JSONObject res = JSONObject.parseObject((String)result);
                if (res.getInteger("code") == 0) {
                    JSONObject data = res.getJSONObject("data");
                    if (!Objects.equals(data.getLong("tenantId"), InvocationInfoProxy.getTenantid())) {
                        return CommonResponse.error((String)"\u5f53\u524d\u79df\u6237\u4e0e\u76ee\u6807\u4f9b\u5e94\u5546\u5f15\u5165\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u63a8\u9001\u6570\u636e\uff01");
                    }
                    String tenant = data.getString("tenant");
                    if (StringUtils.isNotEmpty((CharSequence)tenant)) {
                        return this.exchangeDataAndFilesWithOtherTenant(url, params, tenant, files);
                    }
                    return CommonResponse.error((String)"\u67e5\u8be2\u8be5\u4f9b\u5e94\u5546\u672a\u534f\u540c\uff0c\u65e0\u6cd5\u63a8\u9001\u6570\u636e\uff01");
                }
                return CommonResponse.error((String)"\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            return CommonResponse.error((String)"\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff01=>" + e.getMessage()));
        }
    }

    public CommonResponse<JSONObject> getAuthInfoByTenantId(String tenantId) {
        JSONObject auth;
        block5: {
            auth = new JSONObject();
            try {
                if (this.redisTemplate.opsForValue().get((Object)("Enterprise-Open-Api-Info-" + tenantId)) != null) break block5;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("tenantId", tenantId);
                String result = ReferHttpClientUtils.get(this.environmentTools.getBaseHost() + "ejc-idm-web/enterprise/queryEnByTetId", params, ReferHttpClientUtils.getHeaders());
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    JSONObject res = JSONObject.parseObject((String)result);
                    if (res.getInteger("code") == 0) {
                        JSONObject data = res.getJSONObject("data");
                        String appId = data.getString("dataAppId");
                        String secret = data.getString("dataAppSecret");
                        if (StringUtils.isEmpty((CharSequence)appId) || StringUtils.isEmpty((CharSequence)secret)) {
                            return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606fdataAppId\u6216\u8005dataAppSecret\u4e3a\u7a7a\uff01");
                        }
                        this.redisTemplate.opsForValue().set((Object)("Enterprise-Open-Api-Info-" + tenantId), (Object)(appId + "------" + secret), 2L, TimeUnit.DAYS);
                        break block5;
                    }
                    return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
                }
                return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            catch (Exception e) {
                return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        String cacheData = Objects.requireNonNull(this.redisTemplate.opsForValue().get((Object)("Enterprise-Open-Api-Info-" + tenantId))).toString();
        String appHost = this.environmentTools.getBaseHost();
        String appId = cacheData.split("------")[0];
        String appSecret = cacheData.split("------")[1];
        auth.put("appHost", (Object)appHost);
        auth.put("appId", (Object)appId);
        auth.put("appSecret", (Object)appSecret);
        return CommonResponse.success((Object)auth);
    }
}

