/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.refer.common.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.common.service.CommonReferService;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"commonrefer"})
public class CommonReferController {
    private static final String REFER_CACHE_KEY = "refer_cache_key:";
    @Autowired
    RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private CommonReferService commonReferService;

    @RequestMapping(value={"getrefervalue"})
    @ResponseBody
    public JSONArray getCommonReferData(@RequestParam Map<String, Object> refMapList) {
        return this.commonReferService.getReferEntity(refMapList);
    }

    @RequestMapping(value={"getAuditInfo"})
    @ResponseBody
    public JSONObject getAuditInfo(@RequestParam Map<String, Object> refMapList) {
        return this.commonReferService.getAuditInfoEntity(refMapList);
    }

    @GetMapping(value={"remCache"})
    @ResponseBody
    public CommonResponse<String> remCache(@RequestParam(value="referCode") String referCode, @RequestParam(value="value", required=false) String value) {
        String cacheKey = REFER_CACHE_KEY + referCode;
        if (StringUtils.isNotEmpty((String)value)) {
            cacheKey = REFER_CACHE_KEY + referCode + ":" + value;
        }
        if ("support-defdoc".equals(referCode)) {
            cacheKey = "refer_cache_key:-" + InvocationInfoProxy.getTenantid() + referCode;
            if (StringUtils.isNotEmpty((String)value)) {
                cacheKey = "refer_cache_key:-" + InvocationInfoProxy.getTenantid() + referCode + ":" + value;
            }
        }
        this.redisTemplate.delete((Object)cacheKey);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"remCacheContent"})
    @ResponseBody
    public CommonResponse<String> remCacheContent(@RequestParam(value="codeKey") String codeKey) {
        this.redisTemplate.delete((Object)codeKey);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

