/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.report.param.CommonReportParam;
import com.ejianc.framework.skeleton.report.service.ICommonReportService;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"common/report"})
public class CommonReportController
implements Serializable {
    private static final long serialVersionUID = 8227497523478327706L;
    @Autowired
    private ICommonReportService commonReportService;

    @RequestMapping(value={"parse"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> parse(@RequestBody CommonReportParam reportParam) {
        String sqlContent = reportParam.getSqlContent();
        if (StringUtils.isNotBlank((CharSequence)(sqlContent = JdkBase64Util.decode(sqlContent))) && (sqlContent.toLowerCase().indexOf(";") != -1 || sqlContent.toLowerCase().indexOf("drop") != -1 || sqlContent.toLowerCase().indexOf("insert") != -1 || sqlContent.toLowerCase().indexOf("update") != -1 || sqlContent.toLowerCase().indexOf("delete") != -1)) {
            throw new BusinessException("\u6267\u884csql\u4e2d\u4e0d\u5141\u8bb8\u542b\u6709drop\u3001insert\u3001update\u3001delete\u5173\u952e\u5b57\u3002");
        }
        List<JSONObject> resultList = this.commonReportService.queryReportList(sqlContent, reportParam.getDatasetType(), reportParam.getParams());
        return CommonResponse.success(resultList);
    }
}

