package com.ejianc.framework.skeleton.billState.param;

import com.alibaba.fastjson.JSONArray;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class CommonBusinessParam implements Serializable {

	private static final long serialVersionUID = 3219332840190501812L;

	private Long billId; // 单据主键ID

	private Integer billState; // 单据状态

	private Long metadataId; // 元数据ID

	private String billTypeCode; // 单据类型编号

	private String taskId; // 当前审批节点id

	private Boolean isEnd; // 单据类型编号（审批中事件使用）

	private String sign; // 当前审批节点标志（审批中事件使用）

	private Map<String,Object> other; // 其他参数（审批中事件使用）

	private String taskKey; // 当前审批节点key

	private String taskName; // 当前审批节点名称

	/*****
	 * taskKey    审批节点key
	 * taskName   审批节点名称
	 * sign       节点标志
	 * approveUserList  审批人员(List<String>)
	 * *****/
	private JSONArray newApproveInfo;

	private String rejectTaskKey; // 驳回到的审批节点key
	private String rejectTaskName; // 驳回到的审批节点名称
	private String rejectTaskSign; // 驳回到的审批节点标志

	/*****
	 * 人员id：人员名称
	 * *****/
	private Map<String, String> rejectTaskUserInfo; // 驳回到的审批节点人员信息
	
	public Long getBillId() {
		return billId;
	}

	public void setBillId(Long billId) {
		this.billId = billId;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public Long getMetadataId() {
		return metadataId;
	}

	public void setMetadataId(Long metadataId) {
		this.metadataId = metadataId;
	}

	public String getBillTypeCode() {
		return billTypeCode;
	}

	public void setBillTypeCode(String billTypeCode) {
		this.billTypeCode = billTypeCode;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public Boolean getIsEnd() {
		return isEnd;
	}

	public void setIsEnd(Boolean isEnd) {
		this.isEnd = isEnd;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public Map<String, Object> getOther() {
		return other;
	}

	public void setOther(Map<String, Object> other) {
		this.other = other;
	}

	public String getTaskKey() {
		return taskKey;
	}

	public void setTaskKey(String taskKey) {
		this.taskKey = taskKey;
	}

	public String getTaskName() {
		return taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public JSONArray getNewApproveInfo() {
		return newApproveInfo;
	}

	public void setNewApproveInfo(JSONArray newApproveInfo) {
		this.newApproveInfo = newApproveInfo;
	}

	public String getRejectTaskKey() {
		return rejectTaskKey;
	}

	public void setRejectTaskKey(String rejectTaskKey) {
		this.rejectTaskKey = rejectTaskKey;
	}

	public String getRejectTaskName() {
		return rejectTaskName;
	}

	public void setRejectTaskName(String rejectTaskName) {
		this.rejectTaskName = rejectTaskName;
	}

	public String getRejectTaskSign() {
		return rejectTaskSign;
	}

	public void setRejectTaskSign(String rejectTaskSign) {
		this.rejectTaskSign = rejectTaskSign;
	}

	public Map<String, String> getRejectTaskUserInfo() {
		return rejectTaskUserInfo;
	}

	public void setRejectTaskUserInfo(Map<String, String> rejectTaskUserInfo) {
		this.rejectTaskUserInfo = rejectTaskUserInfo;
	}
}
