package com.ejianc.framework.skeleton.dataPush;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.web.bind.annotation.RequestMethod;

import java.io.InputStream;
import java.util.Map;


public interface IDataPushService {

	/**
	 * 向任意租户推送数据
	 *
	 * @param targetTenantId  目标租户id 必填
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,以/开头 必填
	 * @param method          RequestMethod.POST  或者 RequestMethod.GET  必填
	 * @param params          请求的数据 post方式必填
	 * @return
	 */
	CommonResponse<String> exchangeDataWithOtherTenant(
			String url,
			RequestMethod method,
			String params,
			String targetTenantId
	);
	/**
	 *
	 * 向任意租户推送数据 携带文件
	 *
	 * @param targetTenantId  目标租户id 必填
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,以/开头 必填
	 * @param params          参数
	 * @param files           文件列表
	 * @return
	 */
	CommonResponse<String> exchangeDataAndFilesWithOtherTenant(
			String url,
			Map<String, String> params,
			String targetTenantId,
			Map<String, Map<String, InputStream>> files
	);

	/**
	 * 向任意租户推送数据
	 *
	 * @param supplierId  目标租户id 必填
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,以/开头 必填
	 * @param method          RequestMethod.POST  或者 RequestMethod.GET  必填
	 * @param params          请求的数据 post方式必填
	 * @return
	 */
	CommonResponse<String> exchangeDataWithSupplier(
			String url,
			RequestMethod method,
			String params,
			String supplierId
	);
	/**
	 *
	 * 向任意租户推送数据 携带文件
	 *
	 * @param supplierId  目标租户id 必填
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,以/开头 必填
	 * @param params          参数
	 * @param files           文件列表
	 * @return
	 */
	CommonResponse<String> exchangeDataAndFilesWithSupplier(
			String url,
			Map<String, String> params,
			String supplierId,
			Map<String, Map<String, InputStream>> files
	);
}
