package com.ejianc.framework.skeleton.fields.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.controller.param.CostParameter;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**  
  * QueryFields公共服务
  * 
  * @author liyongjia  
  * @date 2020年5月28日  
  */
@Controller
@RequestMapping(value = "commonFields")
public class CommenQueryFieldsController {
	private final static org.slf4j.Logger logger = LoggerFactory.getLogger(CommenQueryFieldsController.class);

	@Autowired
	private ICommenQueryFieldsService commenQueryFieldsService;
	/**
	 * 
	 * 根据数据表查询该表中对应的字段
	 * 
	 **/
	@RequestMapping(value = "queryFieldsByTableName", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<MdAttributeVO>> queryFieldsByTableName(@RequestParam String tableName,@RequestParam String databaseName) {
		if(StringUtils.isBlank(tableName)) {
			logger.error("数据库表不能为空！");
			return CommonResponse.error("数据库表不能为空");
		}
		List<MdAttributeVO> result =  commenQueryFieldsService.queryFieldsByTableName(tableName,databaseName);
		return CommonResponse.success(result);
	}

	/**
	 * 执行SQL查询匹配数据列表
	 *
	 * @param selectSql
	 * @return
	 */
	@PostMapping(value = "queryDataList")
	@ResponseBody
	public CommonResponse<List<JSONObject>> queryDataList(@RequestBody String selectSql) {
		if(StringUtils.isBlank(selectSql)) {
			return CommonResponse.error("查询语句不能为空!");
		}
		if(selectSql.toLowerCase().indexOf(";") >=0 || selectSql.toLowerCase().indexOf("drop") >=0 
				|| selectSql.toLowerCase().indexOf("insert") >=0 || selectSql.toLowerCase().indexOf("delete") >=0 
				|| selectSql.toLowerCase().indexOf("update") >=0) {
			throw new BusinessException("执行sql中不允许含有drop、insert、update、delete关键字。");
		}
		return CommonResponse.success(commenQueryFieldsService.queryDataList(selectSql));
	}
	
	/**
	 * 
	 * 查询成本数据
	 * 
	 **/
	@RequestMapping(value = "queryCostDatas", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<Map<String, Object>>> queryCostDatas(@RequestBody CostParameter costParameter) {
		if(StringUtils.isBlank(costParameter.getParameter())) {
			return CommonResponse.error("参数不能为空");
		}
		if(StringUtils.isBlank(costParameter.getTableName())) {
			return CommonResponse.error("表名不能为空");
		}
		if(StringUtils.isBlank(costParameter.getCondition())) {
			return CommonResponse.error("条件不能为空");
		}
		List<Map<String, Object>> result =  commenQueryFieldsService.queryCostDatas(costParameter);
		return CommonResponse.success(result);
	}
	
	/**
	 * 修改业务表中： proportion_flag  分摊状态(1:是，0：否)
	 * 
	 * @param billTypeCode
	 * @param billId
	 * @return
	 */
	@RequestMapping(value = "updateProportionFlag", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> updateProportionFlag(@RequestBody JSONObject jsonObject) {
		if(StringUtils.isBlank(jsonObject.getString("billId"))) {
			return CommonResponse.error("单据Id不能为空");
		}
		if(StringUtils.isBlank(jsonObject.getString("tableName"))) {
			return CommonResponse.error("表名不能为空");
		}
		if(StringUtils.isBlank(jsonObject.getString("proportionFlag"))) {
			return CommonResponse.error("分摊状态不能为空");
		}
		commenQueryFieldsService.updateProportionFlagDb(jsonObject);
		return CommonResponse.success();
	}
}
