package com.ejianc.framework.skeleton.util;

import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.ejianc.framework.core.context.ContextCoreUtil;

import cn.hutool.crypto.digest.DigestUtil;

@SuppressWarnings("unchecked")
public class DataTransferEncrypt {
	
	private final static String salt = "21ba97d3d42d079d";
	private final static String HttpSecurityKey = "http-security-key:";
	
	
	public static Boolean encrypt(String content) {
		RedisTemplate<String, String> redisTemplate = ContextCoreUtil.getBean("redisTemplate", RedisTemplate.class);
		String newContent = content+"_"+salt;
		redisTemplate.opsForValue().set(HttpSecurityKey+content, DigestUtil.md5Hex(newContent), 1, TimeUnit.MINUTES);
		return true;
	}
	
	public static Boolean validKey() {
		try{
			HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
			String httpSecurityKey = request.getHeader("http-security-key");
	    	if(StringUtils.isBlank(httpSecurityKey)) {
	    		return false;
	    	}
			
			RedisTemplate<String, String> redisTemplate = ContextCoreUtil.getBean("redisTemplate", RedisTemplate.class);
			String newContent = httpSecurityKey+"_"+salt;
			String securityKey = DigestUtil.md5Hex(newContent);
			String redisKey = redisTemplate.opsForValue().get(HttpSecurityKey+httpSecurityKey);
			
			if(securityKey.equals(redisKey)) {
				redisTemplate.delete(HttpSecurityKey+httpSecurityKey);
				return true;
			}
			return false;
		}catch(Exception e) {}
		return true;
	}
}
