package com.ejianc.framework.skeleton.billTenant.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.billTenant.mapper.BillTenantMapper;
import com.ejianc.framework.skeleton.billTenant.service.IBillTenantService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.*;

/**  
  * Title: BillTenantServiceImpl
  * Description: 租户单据统计实现
  * @author mrsir
  * @date 2023-05-26
  */
@Service
public class BillTenantServiceImpl implements IBillTenantService {
	private final Logger logger = LoggerFactory.getLogger(getClass());
	@Autowired
	private BillTenantMapper billTenantMapper;



	/**
	 * 根据租户分组查询每个租户制单数量
	 *
	 * @param tableName
	 * @return
	 */
	@Override
	public List<JSONObject> queryTenantTotalBill(String tableName) {
		return billTenantMapper.queryTenantTotalBill(tableName);
	}

	@Override
	public int queryTenantTodayBill(String tableName, String startDate, String endDate,String tenantId) {
		return billTenantMapper.queryTenantTodayBill(tableName,startDate,endDate,tenantId);
	}
}
