package com.ejianc.framework.skeleton.template.es;

import static java.util.stream.Collectors.toList;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;

public class TableInfoTool {
	private static Logger logger = LoggerFactory.getLogger(TableInfoTool.class);
	
	public static TableInfo initTableInfo(Class<?> clazz) {
		TableInfo tableInfo = new TableInfo();
        
		initTableName(clazz, tableInfo);
        /* 初始化字段相关 */
        initTableFields(clazz, tableInfo);
	        
		return tableInfo;
	}
	
	static void initTableName(Class<?> clazz, TableInfo tableInfo) {

		/* 设置表名 */
		TableName table = clazz.getAnnotation(TableName.class);
		String tableName = clazz.getSimpleName();
		if (table != null && StringUtils.isNotEmpty(table.value())) {
			tableName = table.value();
		} else {
			// 开启表名下划线申明
			tableName = StringUtils.camelToUnderline(tableName);

		}
		tableInfo.setTableName(tableName);
	}
	
	static void initTableFields(Class<?> clazz, TableInfo tableInfo) {
		GlobalConfig globalConfig= GlobalConfigUtils.defaults();
		/* 数据库全局配置 */
		List<Field> list = getAllFields(clazz);
		// 标记是否读取到主键
		boolean isReadPK = false;
		// 是否存在 @TableId 注解
		boolean existTableId = isExistTableId(list);

		List<TableFieldInfo> fieldList = new ArrayList<>();
		for (Field field : list) {
			/*
			 * 主键ID 初始化
			 */
			if (!isReadPK) {
				if (existTableId) {
					isReadPK = initTableIdWithAnnotation(tableInfo, field, clazz);
				} else {
					isReadPK = initTableIdWithoutAnnotation(tableInfo, field, clazz);
				}
				if (isReadPK) {
					continue;
				}
			}
			/* 有 @TableField 注解的字段初始化 */
			if (initTableFieldWithAnnotation(globalConfig.getDbConfig(), tableInfo, fieldList, field, clazz)) {
				continue;
			}

			/* 无 @TableField 注解的字段初始化 */
			fieldList.add(new TableFieldInfo(globalConfig.getDbConfig(), tableInfo, field));
		}

		/* 字段列表 */
		tableInfo.setFieldList(fieldList);

		/* 未发现主键注解，提示警告信息 */
		if (StringUtils.isEmpty(tableInfo.getKeyColumn())) {
			logger.warn(String.format("Warn: Could not find @TableId in Class: %s.", clazz.getName()));
		}
	}
	
	static List<Field> getAllFields(Class<?> clazz) {
		List<Field> fieldList = ReflectionKit.getFieldList(ClassUtils.getUserClass(clazz));
		if (CollectionUtils.isNotEmpty(fieldList)) {
			return fieldList.stream().filter(i -> {
				/* 过滤注解非表字段属性 */
				TableField tableField = i.getAnnotation(TableField.class);
				return (tableField == null || tableField.exist());
			}).collect(toList());
		}
		return fieldList;
	}

	static boolean isExistTableId(List<Field> list) {
		for (Field field : list) {
			TableId tableId = field.getAnnotation(TableId.class);
			if (tableId != null) {
				return true;
			}
		}
		return false;
	}

	private static boolean initTableIdWithAnnotation(TableInfo tableInfo, Field field,
			Class<?> clazz) {
		TableId tableId = field.getAnnotation(TableId.class);
		boolean underCamel = true;
		if (tableId != null) {
			if (StringUtils.isEmpty(tableInfo.getKeyColumn())) {
				
				/* 字段 */
				String column = field.getName();
				if (StringUtils.isNotEmpty(tableId.value())) {
					column = tableId.value();
				} else {
					// 开启字段下划线申明
					if (underCamel) {
						column = StringUtils.camelToUnderline(column);
					}
				}
				tableInfo.setClazz(field.getDeclaringClass()).setKeyColumn(column).setKeyProperty(field.getName());
				return true;
			} 
		}
		return false;
	}
	
	private static boolean initTableIdWithoutAnnotation(TableInfo tableInfo,
			Field field, Class<?> clazz) {
		String column = field.getName();

		if ( "id".equalsIgnoreCase(column)) {
			if (StringUtils.isEmpty(tableInfo.getKeyColumn())) {
				tableInfo.setKeyColumn(column).setKeyProperty(field.getName())
						.setClazz(field.getDeclaringClass());
				return true;
			} 
		}
		return false;
	}
	
	private static boolean initTableFieldWithAnnotation(GlobalConfig.DbConfig dbConfig,TableInfo tableInfo,
			List<TableFieldInfo> fieldList, Field field, Class<?> clazz) {
		/* 获取注解属性，自定义字段 */
		TableField tableField = field.getAnnotation(TableField.class);
		if (null == tableField) {
			return false;
		}
		String columnName = field.getName();
		if (StringUtils.isNotEmpty(tableField.value())) {
			columnName = tableField.value();
		}
		/*
		 * el 语法支持，可以传入多个参数以逗号分开
		 */
		String el = field.getName();
		if (StringUtils.isNotEmpty(tableField.el())) {
			el = tableField.el();
		}
		String[] columns = columnName.split(";");
		String[] els = el.split(";");
		if (columns.length == els.length) {
			for (int i = 0; i < columns.length; i++) {
				fieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, columns[i], els[i], tableField));
			}
			return true;
		}
		return false;
	}

	

}
