package com.ejianc.business.steelstructure.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.steelstructure.finance.bean.PaymentApplyEntity;
import com.ejianc.business.steelstructure.finance.service.IPaymentApplyService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 付款申请主实体
 *
 * @author generator
 */
@RestController
@RequestMapping("paymentApply")
public class PaymentApplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IPaymentApplyService service;

    @Autowired
    private IContractPoolApi contractPoolApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<PaymentApplyVO> saveOrUpdate(@RequestBody PaymentApplyVO saveOrUpdateVO) {
        //校验，扣减预付款金额不能大于待扣回
        if(null != saveOrUpdateVO.getDeductAdvancePayment() && null != saveOrUpdateVO.getPendDeductAdvancePayment()
                && saveOrUpdateVO.getDeductAdvancePayment().compareTo(saveOrUpdateVO.getPendDeductAdvancePayment()) > 0) {
            return CommonResponse.error("扣减预付款金额不能大于待扣回付款金额!");
        }

        Integer paymentContractFlag = saveOrUpdateVO.getPaymentContractFlag();// 是否有合同：1无，0有
        Integer personalPrepaid = saveOrUpdateVO.getPersonalPrepaid();// 是否个人垫付：1是，0否
        if (paymentContractFlag == 0) {
            // 有合同  收款人 = 供应商
            saveOrUpdateVO.setPayeeId(saveOrUpdateVO.getSupplierId());
            saveOrUpdateVO.setPayeeName(saveOrUpdateVO.getSupplierName());
        } else {
            // 无合同
            if (personalPrepaid == 0) {
                // 非个人垫付，收款人 = 供应商
                saveOrUpdateVO.setPayeeId(saveOrUpdateVO.getSupplierId());
                saveOrUpdateVO.setPayeeName(saveOrUpdateVO.getSupplierName());
            }
        }
        //如果当前条件能不能生成付款申请单 返回错误信息 这里是无合同付款
        if (null == saveOrUpdateVO.getId() && saveOrUpdateVO.getPaymentContractFlag() == 1) {
            CommonResponse<PaymentApplyVO> unusedResult = service.queryUnusedPaymentApply(saveOrUpdateVO.getPaymentType(), saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getSupplierId(), saveOrUpdateVO.getApplyDate());
            if (!unusedResult.isSuccess()) {
                return CommonResponse.error(unusedResult.getMsg());
            }
        }

        if(null == saveOrUpdateVO.getId() && null != saveOrUpdateVO.getContractId()) {
            //保存合同履约状态
            CommonResponse<ContractPoolVO> contractResp = contractPoolApi.queryById(saveOrUpdateVO.getContractId());
            if(!contractResp.isSuccess()) {
                return CommonResponse.error("操作失败，获取合同信息失败！");
            }
            saveOrUpdateVO.setContractPerformanceStatus(contractResp.getData().getPerformanceStatus());
        }

        PaymentApplyVO vo = service.savePaymentApply(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<PaymentApplyVO> queryDetail(Long id) {
        PaymentApplyEntity entity = service.selectById(id);
        PaymentApplyVO vo = BeanMapper.map(entity, PaymentApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaymentApplyVO> vos) {
        service.batchDel(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @return
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<PaymentApplyEntity> pageData = service.queryPage(param, false);
        List<PaymentApplyVO> paymentApplyVOS = BeanMapper.mapList(pageData.getRecords(), PaymentApplyVO.class);
        for (PaymentApplyVO item : paymentApplyVOS) {
            item.setApplyDateTime(item.getApplyDate());
        }
        JSONObject page = new JSONObject();
        page.put("records", paymentApplyVOS);
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());

        //页面统计，累计申请金额，累计批复金额，累计实付金额
        Map<String, Object> sumMnyMap = service.countSumMny(param);
        page.put("sumMnyMap", sumMnyMap);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * 根据条件查询累计申请金额-totalApplyMny，累计批复金额-totalApprovalMny，累计实付金额-totalActualMny
     *
     * @param paymentApplyVO
     * @return
     */
    @PostMapping(value = "/countTotalPayApplyMny")
    public CommonResponse<Map<String, Object>> countTotalPayApplyMny(@RequestBody PaymentApplyVO paymentApplyVO) {
        QueryParam param = new QueryParam();
        if(null != paymentApplyVO.getProjectId()) {
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, paymentApplyVO.getProjectId()));
        }
        if(null != paymentApplyVO.getContractId()) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, paymentApplyVO.getContractId()));
        }
        if(null != paymentApplyVO.getSourceCategoryType()) {
            param.getParams().put("sourceCategoryType", new Parameter(QueryParam.EQ, paymentApplyVO.getSourceCategoryType()));
        }

        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStates));

        return CommonResponse.success(service.countSumMny(param));
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 查询当前合同历史数据
     * 累计结算金额
     * 截止上期已申请金额
     * 累计实付金额
     * 预付已申请金额 1
     *
     * @param entity
     * @return
     */
    @RequestMapping(value = "/queryLastApply", method = RequestMethod.POST)
    public CommonResponse<PaymentApplyVO> queryLastApply(@RequestBody PaymentApplyVO entity) {
        if (entity.getContractId() == null || entity.getProjectId() == null) {
            throw new BusinessException("请检查合同id或项目是否为空！");
        }
        //查询当前合同下是否有未生效的付款申请 不区分类型

        CommonResponse<PaymentApplyVO> paymentApplyVOCommonResponse = service.checkPayApply(entity);
//        if (paymentApplyVOCommonResponse.isSuccess()) {
//            entity.setApplyDate(paymentApplyVOCommonResponse.getData().getApplyDate());
//            entity.setMinApplyDate(paymentApplyVOCommonResponse.getData().getMinApplyDate());
//            if (entity.getPaymentType() == 1) {
//                entity.setAdvanceApplyMny(service.queryAdvanceApplyMny(entity));
//
//            } else if (entity.getPaymentType() == 0) {
//                entity.setPendDeductAdvancePayment(service.queryPendDeduct(entity));
//            } else if (entity.getPaymentType() == 2) {
//                entity.setTotalLitigationMny(service.queryTotalLitigationMny(entity));
//                entity.setLastLitigationMny(service.queryLastLitigationMny(entity));
//            }
//            entity.setTotalLawsuitMny(service.queryTotalLawsuitMny(entity));
//            entity.setLastApplyMny(service.queryLastApplyMny(entity));
//            entity.setTotalPayMny(service.queryTotalPayMny(entity));
//            entity.setTotalPerformanceMny(service.queryContractHonourMny(entity));
//
//            //劳务分包合同则查 合同累计批复金额、累计实付金额
//            if (null != entity.getSourceCategoryType() && (ContractTypeEnum.劳务分包合同.getTypeCode().equals(entity.getSourceCategoryType()) || ContractTypeEnum.专业分包合同.getTypeCode().equals(entity.getSourceCategoryType()))){
//                service.setTotalContractRelateMny(entity);
//            }
//            return CommonResponse.success("查询数据成功", entity);
//        }
        return paymentApplyVOCommonResponse;
    }

    @RequestMapping(value = "/queryAlreadyApplyMny", method = RequestMethod.POST)
    public CommonResponse<Map<String, BigDecimal>> queryAlreadyApplyMny(@RequestBody List<String> idList) {
        Map<String, BigDecimal> map = new HashMap<>();
        for (String id : idList) {
            BigDecimal bigDecimal = service.queryAlreadyApplyMny(id);
            map.put(id, bigDecimal);
        }
        return CommonResponse.success("查询数据成功", map);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = queryList(param);
        List<PaymentApplyVO> paymentApplyVOList = new ArrayList<>();
        if (null != commonResponse.getData()) {
            paymentApplyVOList = (List<PaymentApplyVO>) commonResponse.getData().get("records");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

            if (null != paymentApplyVOList && paymentApplyVOList.size() > 0) {
                paymentApplyVOList.forEach(c -> {
                    c.setApplyDateStr(sdf.format(c.getApplyDate()));
                    if (null != c.getPaymentType()) {
                        if (c.getPaymentType().equals(0)) {
                            c.setPaymentTypeName("进度款");
                        } else if (c.getPaymentType().equals(1)) {
                            c.setPaymentTypeName("预付款");
                        } else if (c.getPaymentType().equals(2)) {
                            c.setPaymentTypeName("诉讼款");
                        } else if (c.getPaymentType().equals(3)) {
                            c.setPaymentTypeName("零星材料");
                        } else if (c.getPaymentType().equals(4)) {
                            c.setPaymentTypeName("临时机械");
                        }
                    }
                    //流程状态
                    c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
                });
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", paymentApplyVOList);
        if (null != param.getParams().get("paymentContractFlag")) {
            //导出无合同付款申请列表
            if (param.getParams().get("paymentContractFlag").getValue().equals(1)) {
                ExcelExport.getInstance().export("noContractPaymentApply-export.xlsx", beans, response);
            } else {
                ExcelExport.getInstance().export("contractPaymentApply-export.xlsx", beans, response);
            }
        }
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPaymentApplyData", method = RequestMethod.GET)
    public CommonResponse<IPage<PaymentApplyVO>> refPaymentApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 处理condition */
        if (StringUtils.isNotBlank(condition)) {
            JSONObject conditionJson = JSONObject.parseObject(condition);

            String projectId = conditionJson.getString("projectId");
            String orgId = conditionJson.getString("orgId");
            String orgType = conditionJson.getString("orgType");
            String paymentContractFlag = conditionJson.getString("paymentContractFlag");

            if(StringUtils.isBlank(projectId) && StringUtils.isBlank(orgId) && StringUtils.isBlank(orgType)) {
                return CommonResponse.error("查询失败，缺少查询参数projectId或组织过滤参数-orgId,orgType！");
            }

            if(StringUtils.isNotBlank(paymentContractFlag)){
                param.getParams().put("paymentContractFlag",new Parameter(QueryParam.EQ,paymentContractFlag));
            }else {
                return CommonResponse.error("查询失败，缺少查询查询合同类型 是否有合同");
            }


            if (StringUtils.isNotBlank(projectId)){
                logger.info("condition中projectId：{}", projectId);
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, Long.valueOf(projectId)));
            } else {
                if(StringUtils.isBlank(orgId)) {
                    return CommonResponse.error("查询失败，缺少组织过滤参数-orgId！");
                }
                if(StringUtils.isBlank(orgType)) {
                    return CommonResponse.error("查询失败，缺少组织过滤参数-orgType！");
                }
                //查询本下范围内日的合同
                if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(orgType)) {
                    //按项目部过滤
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, Long.valueOf(orgId)));
                } else {
                    //按组织过滤
                    CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(Long.valueOf(orgId));
                    if(!orgResp.isSuccess()) {
                        logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                        return CommonResponse.error("查询失败，获取组织信息失败！");
                    }
                    param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                            orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                }
            }
        }else {
            return CommonResponse.error("查询失败，缺少查询参数projectId或组织过滤参数-orgId,orgType！");
        }
        //查询未关闭的付款申请单
        param.getParams().put("close_state",new Parameter(QueryParam.EQ,0));
        IPage<PaymentApplyEntity> page = service.queryPage(param, false);
        IPage<PaymentApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PaymentApplyVO> paymentApplyVOS = BeanMapper.mapList(page.getRecords(), PaymentApplyVO.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        paymentApplyVOS.forEach(c -> {
                    c.setApplyDateStr(sdf.format(c.getApplyDate()));
                    if (null != c.getPaymentType()) {
                        if (c.getPaymentType().equals(0)) {
                            c.setPaymentTypeName("进度款");
                        } else if (c.getPaymentType().equals(1)) {
                            c.setPaymentTypeName("预付款");
                        } else if (c.getPaymentType().equals(2)) {
                            c.setPaymentTypeName("诉讼款");
                        } else if (c.getPaymentType().equals(3)) {
                            c.setPaymentTypeName("零星材料");
                        } else if (c.getPaymentType().equals(4)) {
                            c.setPaymentTypeName("临时机械");
                        }
                    }
                });
        pageData.setRecords(paymentApplyVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * 查询符合当前条件的申请能否创建，并返回当前可用申请时间
     * 同一项目+供应商+付款类型 只能存在一份非生效状态的付款申请（区分付款类型）；
     *
     * @param paymentType
     * @param projectId
     * @param supplierId
     * @return
     */
    @RequestMapping(value = "/queryUnusedPaymentApply", method = RequestMethod.GET)
    public CommonResponse<PaymentApplyVO> queryUnusedPaymentApply(Integer paymentType, Long projectId, Long supplierId, Date applyDate) {
        return service.queryUnusedPaymentApply(paymentType, projectId, supplierId, applyDate);
    }

    @PostMapping(value = "/queryDataModelInfo")
    public CommonResponse<List<JSONObject>> queryDataModelInfo(@RequestBody JSONObject jsonParam) {
        List<JSONObject> resp = new ArrayList<>();
        logger.info("查询无合同付款数据模型参数-{},",jsonParam.toJSONString());
        if(null == jsonParam || jsonParam.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject billJson = jsonParam.getJSONObject("bill");
        if(null == billJson || billJson.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject projectInfo = billJson.getJSONObject("projectId");
        if(null == projectInfo || projectInfo.isEmpty()) {
            return CommonResponse.success(resp);
        }


        JSONObject data = service.queryDataModelInfo(projectInfo.getLong("id"));
        data.put("projectName", projectInfo.getString("name"));
        resp.add(data);
        return CommonResponse.success(resp);
    }
//    @PostMapping(value = "/queryDataModelEquip")
//    public CommonResponse<List<JSONObject>> queryDataModelEquip(@RequestBody JSONObject jsonParam) {
//        List<JSONObject> resp = new ArrayList<>();
//        logger.info("查询无合同付款数据模型参数-{},",jsonParam.toJSONString());
//        if(null == jsonParam || jsonParam.isEmpty()) {
//            return CommonResponse.success(resp);
//        }
//        JSONObject billJson = jsonParam.getJSONObject("bill");
//        if(null == billJson || billJson.isEmpty()) {
//            return CommonResponse.success(resp);
//        }
//        JSONObject projectInfo = billJson.getJSONObject("projectId");
//        if(null == projectInfo || projectInfo.isEmpty()) {
//            return CommonResponse.success(resp);
//        }
//        List<JSONObject> data = service.queryDataModelEquip(projectInfo.getLong("id"));
//        return CommonResponse.success(data);
//    }
//    @PostMapping(value = "/queryDataModelMaterial")
//    public CommonResponse<List<JSONObject>> queryDataModelMaterial(@RequestBody JSONObject jsonParam) {
//        List<JSONObject> resp = new ArrayList<>();
//        logger.info("查询无合同付款数据模型参数-{},",jsonParam.toJSONString());
//        if(null == jsonParam || jsonParam.isEmpty()) {
//            return CommonResponse.success(resp);
//        }
//        JSONObject billJson = jsonParam.getJSONObject("bill");
//        if(null == billJson || billJson.isEmpty()) {
//            return CommonResponse.success(resp);
//        }
//        JSONObject projectInfo = billJson.getJSONObject("projectId");
//        if(null == projectInfo || projectInfo.isEmpty()) {
//            return CommonResponse.success(resp);
//        }
//        List<JSONObject> data = service.queryDataModelMaterial(projectInfo.getLong("id"));
//        return CommonResponse.success(data);
//    }

//    /**
//     * @Description updateCloseState 修改关闭状态
//     */
//    @RequestMapping(value = "/updateCloseState", method = RequestMethod.POST)
//    public CommonResponse<PaymentApplyVO> updateCloseState(@RequestBody PaymentApplyVO saveOrUpdateVO) {
//        //后期修改
//        //关闭后该单据的申请金额不在占用结算单累计申请金额，由实际付款金额占用结算单累计申请金额；
//        //传财务系统的付款申请总金额扣减该单据的（申请金额-实际付款金额）；
//        PaymentApplyEntity entity = service.selectById(saveOrUpdateVO.getId());
//        if (null != entity) {
//            entity.setCloseState(saveOrUpdateVO.getCloseState());
//        }
//        if(!(BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState()))) {
//            return CommonResponse.error("操作失败，未生效的付款单不能进行该操作！");
//        }
//
//        return service.updateCloseState(entity,"关闭");
//    }



}
