package com.ejianc.business.steelstructure.finance.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PaymentTypeEnum {
    正常付款("0", "正常付款"),
    预付款("1", "预付款"),
    诉讼款("2", "诉讼款"),
    零星材料("3", "零星材料"),
    临时机械("4", "临时机械");
    private String code;
    private String description;

    PaymentTypeEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    private static Map<String, PaymentTypeEnum> enumMap = new HashMap<>();

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(PaymentTypeEnum.class).stream().collect(Collectors.toMap(PaymentTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));

    }

    public static PaymentTypeEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }

}
