package com.ejianc.business.steelstructure.finance.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SalaryDetailWorkerPayStateEnum {
    /*
        支付状态：0-待支付，1-支付成功，2-银行支付中，3-支付失败
     */
    待支付("0", "待支付"),
    支付成功("1", "支付成功"),
    银行支付中("2", "银行支付中"),
    支付失败("3", "支付失败");

    private String code;
    private String description;

    SalaryDetailWorkerPayStateEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    private static Map<String, SalaryDetailWorkerPayStateEnum> enumMap = new HashMap<>();

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(SalaryDetailWorkerPayStateEnum.class).stream().collect(Collectors.toMap(SalaryDetailWorkerPayStateEnum::getCode, Function.identity(), (k1, k2) -> k2));

    }

    public static SalaryDetailWorkerPayStateEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }

}
