package com.ejianc.business.steelstructure.finance.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SalaryPayStateEnum {
    /*

        支付状态：0-待支付，1-支付成功，2-部分支付，3-支付失败，4-支付中
     */
    待支付("0", "待支付"),
    支付成功("1", "支付成功"),
    部分支付("2", "部分支付"),
    支付失败("3", "支付失败"),
    支付中("4", "支付中");

    private String code;
    private String description;

    SalaryPayStateEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    private static Map<String, SalaryPayStateEnum> enumMap = new HashMap<>();

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(SalaryPayStateEnum.class).stream().collect(Collectors.toMap(SalaryPayStateEnum::getCode, Function.identity(), (k1, k2) -> k2));

    }

    public static SalaryPayStateEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }

}
